/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities.internal.condition;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import org.sonatype.nexus.plugins.capabilities.internal.condition.RepositoryConditionSupport;
import org.sonatype.nexus.plugins.capabilities.support.condition.RepositoryConditions;
import org.sonatype.nexus.proxy.events.RepositoryConfigurationUpdatedEvent;
import org.sonatype.nexus.proxy.events.RepositoryRegistryEventAdd;
import org.sonatype.nexus.proxy.events.RepositoryRegistryEventRemove;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.LocalStatus;
import org.sonatype.sisu.goodies.eventbus.EventBus;

public class RepositoryLocalStatusCondition
extends RepositoryConditionSupport {
    private final LocalStatus localStatus;

    public RepositoryLocalStatusCondition(EventBus eventBus, RepositoryRegistry repositoryRegistry, LocalStatus localStatus, RepositoryConditions.RepositoryId repositoryId) {
        super(eventBus, repositoryRegistry, repositoryId);
        this.localStatus = (LocalStatus)Preconditions.checkNotNull((Object)localStatus);
    }

    @Override
    @AllowConcurrentEvents
    @Subscribe
    public void handle(RepositoryRegistryEventAdd event) {
        if (this.sameRepositoryAs(event.getRepository().getId())) {
            this.setSatisfied(this.localStatus.equals((Object)event.getRepository().getLocalStatus()));
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(RepositoryConfigurationUpdatedEvent event) {
        if (this.sameRepositoryAs(event.getRepository().getId())) {
            this.setSatisfied(this.localStatus.equals((Object)event.getRepository().getLocalStatus()));
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(RepositoryRegistryEventRemove event) {
        if (this.sameRepositoryAs(event.getRepository().getId())) {
            this.setSatisfied(false);
        }
    }

    public String toString() {
        try {
            String id = this.getRepositoryId();
            return String.format("Repository '%s' is %s", id, this.localStatus.toString());
        }
        catch (Exception exception) {
            return String.format("Repository '(could not be evaluated)' is %s", this.localStatus.toString());
        }
    }

    @Override
    public String explainSatisfied() {
        String state = this.localStatus.equals((Object)LocalStatus.OUT_OF_SERVICE) ? "out of" : "in";
        try {
            String id = this.getRepositoryId();
            return String.format("Repository '%s' is %s service", id, state);
        }
        catch (Exception exception) {
            return String.format("Repository '(could not be evaluated)' is %s service", state);
        }
    }

    @Override
    public String explainUnsatisfied() {
        String state = this.localStatus.equals((Object)LocalStatus.OUT_OF_SERVICE) ? "in" : "out of";
        try {
            String id = this.getRepositoryId();
            return String.format("Repository '%s' is %s service", id, state);
        }
        catch (Exception exception) {
            return String.format("Repository '(could not be evaluated)' is %s service", state);
        }
    }
}

