/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities.internal.condition;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import org.sonatype.nexus.plugins.capabilities.internal.condition.RepositoryConditionSupport;
import org.sonatype.nexus.plugins.capabilities.support.condition.RepositoryConditions;
import org.sonatype.nexus.proxy.events.RepositoryRegistryEventAdd;
import org.sonatype.nexus.proxy.events.RepositoryRegistryEventRemove;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.sisu.goodies.eventbus.EventBus;

public class RepositoryExistsCondition
extends RepositoryConditionSupport {
    public RepositoryExistsCondition(EventBus eventBus, RepositoryRegistry repositoryRegistry, RepositoryConditions.RepositoryId repositoryId) {
        super(eventBus, repositoryRegistry, repositoryId);
    }

    @Override
    @AllowConcurrentEvents
    @Subscribe
    public void handle(RepositoryRegistryEventAdd event) {
        if (this.sameRepositoryAs(event.getRepository().getId())) {
            this.setSatisfied(true);
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(RepositoryRegistryEventRemove event) {
        if (this.sameRepositoryAs(event.getRepository().getId())) {
            this.setSatisfied(false);
        }
    }

    public String toString() {
        try {
            String id = this.getRepositoryId();
            return String.format("Repository '%s' exists", id);
        }
        catch (Exception exception) {
            return "Repository '(could not be evaluated)' exists";
        }
    }

    @Override
    public String explainSatisfied() {
        try {
            String id = this.getRepositoryId();
            return String.format("Repository '%s' exists", id);
        }
        catch (Exception exception) {
            return "Repository '(could not be evaluated)' exists";
        }
    }

    @Override
    public String explainUnsatisfied() {
        try {
            String id = this.getRepositoryId();
            return String.format("Repository '%s' does not exist", id);
        }
        catch (Exception exception) {
            return "Repository '(could not be evaluated)' does not exist";
        }
    }
}

