/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities.internal.condition;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.sonatype.nexus.plugins.capabilities.CapabilityContext;
import org.sonatype.nexus.plugins.capabilities.CapabilityContextAware;
import org.sonatype.nexus.plugins.capabilities.CapabilityEvent;
import org.sonatype.nexus.plugins.capabilities.CapabilityIdentity;
import org.sonatype.nexus.plugins.capabilities.support.condition.ConditionSupport;
import org.sonatype.nexus.plugins.capabilities.support.condition.RepositoryConditions;
import org.sonatype.nexus.proxy.events.RepositoryRegistryEventAdd;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.sisu.goodies.eventbus.EventBus;

public abstract class RepositoryConditionSupport
extends ConditionSupport
implements CapabilityContextAware {
    private final RepositoryRegistry repositoryRegistry;
    private final RepositoryConditions.RepositoryId repositoryId;
    private final ReentrantReadWriteLock bindLock;
    private CapabilityIdentity capabilityIdentity;
    private String repositoryBeforeLastUpdate;

    public RepositoryConditionSupport(EventBus eventBus, RepositoryRegistry repositoryRegistry, RepositoryConditions.RepositoryId repositoryId) {
        super(eventBus, false);
        this.repositoryRegistry = (RepositoryRegistry)Preconditions.checkNotNull((Object)repositoryRegistry);
        this.repositoryId = (RepositoryConditions.RepositoryId)Preconditions.checkNotNull((Object)repositoryId);
        this.bindLock = new ReentrantReadWriteLock();
    }

    @Override
    public RepositoryConditionSupport setContext(CapabilityContext context) {
        Preconditions.checkState((!this.isActive() ? 1 : 0) != 0, (Object)"Cannot contextualize when already bounded");
        Preconditions.checkState((this.capabilityIdentity == null ? 1 : 0) != 0, (Object)("Already contextualized with id '" + this.capabilityIdentity + "'"));
        this.capabilityIdentity = context.id();
        return this;
    }

    @Override
    protected void doBind() {
        try {
            this.bindLock.writeLock().lock();
            for (Repository repository : this.repositoryRegistry.getRepositories()) {
                this.handle(new RepositoryRegistryEventAdd(this.repositoryRegistry, repository));
            }
        }
        finally {
            this.bindLock.writeLock().unlock();
        }
        this.getEventBus().register((Object)this);
    }

    @Override
    public void doRelease() {
        this.getEventBus().unregister((Object)this);
    }

    public abstract void handle(RepositoryRegistryEventAdd var1);

    @Override
    protected void setSatisfied(boolean satisfied) {
        try {
            this.bindLock.readLock().lock();
            super.setSatisfied(satisfied);
        }
        finally {
            this.bindLock.readLock().unlock();
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(CapabilityEvent.BeforeUpdate event) {
        if (event.getReference().context().id().equals(this.capabilityIdentity)) {
            this.repositoryBeforeLastUpdate = this.getRepositoryId();
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(CapabilityEvent.AfterUpdate event) {
        if (event.getReference().context().id().equals(this.capabilityIdentity) && !this.sameRepositoryAs(this.repositoryBeforeLastUpdate)) {
            try {
                this.bindLock.writeLock().lock();
                for (Repository repository : this.repositoryRegistry.getRepositories()) {
                    this.handle(new RepositoryRegistryEventAdd(this.repositoryRegistry, repository));
                }
            }
            finally {
                this.bindLock.writeLock().unlock();
            }
        }
    }

    protected boolean sameRepositoryAs(String repositoryId) {
        return repositoryId != null && repositoryId.equals(this.getRepositoryId());
    }

    protected String getRepositoryId() {
        return this.repositoryId.get();
    }
}

