/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities.internal.condition;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import org.sonatype.nexus.plugins.capabilities.CapabilityContext;
import org.sonatype.nexus.plugins.capabilities.CapabilityContextAware;
import org.sonatype.nexus.plugins.capabilities.CapabilityEvent;
import org.sonatype.nexus.plugins.capabilities.CapabilityIdentity;
import org.sonatype.nexus.plugins.capabilities.support.condition.ConditionSupport;
import org.sonatype.sisu.goodies.eventbus.EventBus;

public class PassivateCapabilityDuringUpdateCondition
extends ConditionSupport
implements CapabilityContextAware {
    private CapabilityIdentity id;
    private final String[] propertyNames;

    public PassivateCapabilityDuringUpdateCondition(EventBus eventBus, String ... propertyNames) {
        super(eventBus, true);
        this.propertyNames = propertyNames == null || propertyNames.length == 0 ? null : propertyNames;
    }

    @Override
    public PassivateCapabilityDuringUpdateCondition setContext(CapabilityContext context) {
        Preconditions.checkState((!this.isActive() ? 1 : 0) != 0, (Object)"Cannot contextualize when already bounded");
        Preconditions.checkState((this.id == null ? 1 : 0) != 0, (Object)("Already contextualized with id '" + this.id + "'"));
        this.id = context.id();
        return this;
    }

    @Override
    protected void doBind() {
        Preconditions.checkState((this.id != null ? 1 : 0) != 0, (Object)"Capability identity not specified");
        this.getEventBus().register((Object)this);
    }

    @Override
    public void doRelease() {
        this.getEventBus().unregister((Object)this);
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(CapabilityEvent.BeforeUpdate event) {
        if (event.getReference().context().id().equals(this.id)) {
            if (this.propertyNames == null) {
                this.setSatisfied(false);
            } else {
                String[] stringArray = this.propertyNames;
                int n = this.propertyNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String newValue;
                    String propertyName = stringArray[n2];
                    String oldValue = event.properties().get(propertyName);
                    if (oldValue == null) {
                        oldValue = "";
                    }
                    if ((newValue = event.previousProperties().get(propertyName)) == null) {
                        newValue = "";
                    }
                    if (this.isSatisfied() && !oldValue.equals(newValue)) {
                        this.setSatisfied(false);
                    }
                    ++n2;
                }
            }
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(CapabilityEvent.AfterUpdate event) {
        if (event.getReference().context().id().equals(this.id)) {
            this.setSatisfied(true);
        }
    }

    public String toString() {
        return "Passivate during update of " + this.id;
    }

    @Override
    public String explainSatisfied() {
        return "Capability is currently being updated";
    }

    @Override
    public String explainUnsatisfied() {
        return "Capability is not currently being updated";
    }
}

