/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities.internal.condition;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import org.sonatype.nexus.plugins.capabilities.CapabilityContext;
import org.sonatype.nexus.plugins.capabilities.CapabilityContextAware;
import org.sonatype.nexus.plugins.capabilities.CapabilityEvent;
import org.sonatype.nexus.plugins.capabilities.CapabilityIdentity;
import org.sonatype.nexus.plugins.capabilities.Evaluable;
import org.sonatype.nexus.plugins.capabilities.support.condition.ConditionSupport;
import org.sonatype.sisu.goodies.eventbus.EventBus;

public class EvaluableCondition
extends ConditionSupport
implements CapabilityContextAware {
    private CapabilityIdentity capabilityIdentity;
    private final Evaluable evaluable;

    public EvaluableCondition(EventBus eventBus, Evaluable evaluable) {
        super(eventBus, false);
        this.evaluable = (Evaluable)Preconditions.checkNotNull((Object)evaluable);
    }

    @Override
    public EvaluableCondition setContext(CapabilityContext context) {
        Preconditions.checkState((!this.isActive() ? 1 : 0) != 0, (Object)"Cannot contextualize when already bounded");
        Preconditions.checkState((this.capabilityIdentity == null ? 1 : 0) != 0, (Object)("Already contextualized with id '" + this.capabilityIdentity + "'"));
        this.capabilityIdentity = context.id();
        return this;
    }

    @Override
    protected void doBind() {
        Preconditions.checkState((this.capabilityIdentity != null ? 1 : 0) != 0, (Object)"Capability identity not specified");
        this.getEventBus().register((Object)this);
        this.setSatisfied(this.evaluable.isSatisfied());
    }

    @Override
    public void doRelease() {
        this.getEventBus().unregister((Object)this);
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(CapabilityEvent.AfterUpdate event) {
        if (event.getReference().context().id().equals(this.capabilityIdentity)) {
            this.setSatisfied(this.evaluable.isSatisfied());
        }
    }

    public String toString() {
        return this.evaluable.toString();
    }

    @Override
    public String explainSatisfied() {
        return this.evaluable.explainSatisfied();
    }

    @Override
    public String explainUnsatisfied() {
        return this.evaluable.explainUnsatisfied();
    }
}

