/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities.internal.condition;

import com.google.common.base.Preconditions;
import java.security.NoSuchAlgorithmException;
import org.jetbrains.annotations.NonNls;
import org.sonatype.nexus.plugins.capabilities.Condition;
import org.sonatype.nexus.plugins.capabilities.support.condition.ConditionSupport;
import org.sonatype.sisu.goodies.crypto.CryptoHelper;
import org.sonatype.sisu.goodies.eventbus.EventBus;
import org.sonatype.sisu.goodies.i18n.I18N;
import org.sonatype.sisu.goodies.i18n.MessageBundle;

public class CipherKeyHighStrengthCondition
extends ConditionSupport
implements Condition {
    public static final int MIN_BITS = 4096;
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final CryptoHelper crypto;
    private final String transformation;

    public CipherKeyHighStrengthCondition(EventBus eventBus, CryptoHelper crypto, @NonNls String transformation) {
        super(eventBus, false);
        this.crypto = (CryptoHelper)Preconditions.checkNotNull((Object)crypto);
        this.transformation = (String)Preconditions.checkNotNull((Object)transformation);
    }

    @Override
    protected void doBind() {
        this.getEventBus().register((Object)this);
        this.verify();
    }

    @Override
    protected void doRelease() {
        this.getEventBus().unregister((Object)this);
    }

    public String toString() {
        return this.explainSatisfied();
    }

    @Override
    public String explainSatisfied() {
        return messages.satisfied(this.transformation);
    }

    @Override
    public String explainUnsatisfied() {
        return messages.unsatisfied(this.transformation);
    }

    private void verify() {
        try {
            int max = this.crypto.getCipherMaxAllowedKeyLength(this.transformation);
            if (max >= 4096) {
                this.setSatisfied(true);
            } else {
                this.setSatisfied(false);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.setSatisfied(false);
        }
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="JVM supports high-strength '%s' cipher keys")
        public String satisfied(String var1);

        @MessageBundle.DefaultMessage(value="JVM does NOT support high-strength '%s' cipher keys")
        public String unsatisfied(String var1);
    }
}

