/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities.internal.condition;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import org.sonatype.nexus.plugins.capabilities.CapabilityDescriptorRegistry;
import org.sonatype.nexus.plugins.capabilities.CapabilityEvent;
import org.sonatype.nexus.plugins.capabilities.CapabilityReference;
import org.sonatype.nexus.plugins.capabilities.CapabilityRegistry;
import org.sonatype.nexus.plugins.capabilities.CapabilityType;
import org.sonatype.nexus.plugins.capabilities.internal.condition.CapabilityOfTypeExistsCondition;
import org.sonatype.sisu.goodies.eventbus.EventBus;

public class CapabilityOfTypeActiveCondition
extends CapabilityOfTypeExistsCondition {
    public CapabilityOfTypeActiveCondition(EventBus eventBus, CapabilityDescriptorRegistry descriptorRegistry, CapabilityRegistry capabilityRegistry, CapabilityType type) {
        super(eventBus, descriptorRegistry, capabilityRegistry, type);
    }

    @Override
    boolean isSatisfiedBy(CapabilityReference reference) {
        return super.isSatisfiedBy(reference) && reference.context().isActive();
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(CapabilityEvent.AfterActivated event) {
        if (!this.isSatisfied() && this.type.equals(event.getReference().context().type())) {
            this.checkAllCapabilities();
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(CapabilityEvent.BeforePassivated event) {
        if (this.isSatisfied() && this.type.equals(event.getReference().context().type())) {
            this.checkAllCapabilities();
        }
    }

    @Override
    public String toString() {
        return "Active " + this.type;
    }

    @Override
    public String explainSatisfied() {
        return String.valueOf(this.typeName) + " is active";
    }

    @Override
    public String explainUnsatisfied() {
        return String.valueOf(this.typeName) + " is not active";
    }
}

