/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities.internal.condition;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import org.sonatype.nexus.plugins.capabilities.CapabilityContext;
import org.sonatype.nexus.plugins.capabilities.CapabilityContextAware;
import org.sonatype.nexus.plugins.capabilities.CapabilityEvent;
import org.sonatype.nexus.plugins.capabilities.support.condition.ConditionSupport;
import org.sonatype.sisu.goodies.eventbus.EventBus;

public class CapabilityHasNoFailures
extends ConditionSupport
implements CapabilityContextAware {
    private CapabilityContext context;
    private String failingAction;
    private Exception failure;

    public CapabilityHasNoFailures(EventBus eventBus) {
        super(eventBus);
    }

    @Override
    public CapabilityHasNoFailures setContext(CapabilityContext context) {
        Preconditions.checkState((!this.isActive() ? 1 : 0) != 0, (Object)"Cannot contextualize when already bounded");
        Preconditions.checkState((this.context == null ? 1 : 0) != 0, (Object)("Already contextualized with '" + this.context + "'"));
        this.context = context;
        return this;
    }

    @Override
    protected void doBind() {
        Preconditions.checkState((this.context != null ? 1 : 0) != 0, (Object)"Not yet contextualized");
        this.getEventBus().register((Object)this);
        this.failingAction = this.context.failingAction();
        this.failure = this.context.failure();
        this.setSatisfied(this.failure == null);
    }

    @Override
    public void doRelease() {
        this.getEventBus().unregister((Object)this);
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(CapabilityEvent.CallbackFailure event) {
        if (event.getReference().context().id().equals(this.context.id())) {
            this.failingAction = event.failingAction();
            this.failure = event.failure();
            this.setSatisfied(false);
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(CapabilityEvent.CallbackFailureCleared event) {
        if (event.getReference().context().id().equals(this.context.id())) {
            this.failingAction = null;
            this.failure = null;
            this.setSatisfied(true);
        }
    }

    public String toString() {
        return "Has no failures: " + this.context.id();
    }

    @Override
    public String explainSatisfied() {
        return "Capability has not failures";
    }

    @Override
    public String explainUnsatisfied() {
        return String.valueOf(this.failingAction) + " failed: " + this.failure;
    }
}

