/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.plugins.capabilities.CapabilityDescriptor;
import org.sonatype.nexus.plugins.capabilities.CapabilityDescriptorRegistry;
import org.sonatype.nexus.plugins.capabilities.CapabilityFactory;
import org.sonatype.nexus.plugins.capabilities.CapabilityFactoryRegistry;
import org.sonatype.nexus.plugins.capabilities.CapabilityIdentity;
import org.sonatype.nexus.plugins.capabilities.CapabilityType;
import org.sonatype.nexus.plugins.capabilities.Validator;
import org.sonatype.nexus.plugins.capabilities.ValidatorRegistry;
import org.sonatype.nexus.plugins.capabilities.internal.DefaultCapabilityReference;
import org.sonatype.nexus.plugins.capabilities.internal.DefaultCapabilityRegistry;
import org.sonatype.nexus.plugins.capabilities.support.validator.Validators;

@Named
@Singleton
class DefaultValidatorRegistry
implements ValidatorRegistry {
    private final DefaultCapabilityRegistry capabilityRegistry;
    private final CapabilityFactoryRegistry capabilityFactoryRegistry;
    private final CapabilityDescriptorRegistry capabilityDescriptorRegistry;
    private final Validators validators;

    @Inject
    DefaultValidatorRegistry(CapabilityDescriptorRegistry capabilityDescriptorRegistry, CapabilityFactoryRegistry capabilityFactoryRegistry, DefaultCapabilityRegistry capabilityRegistry, Validators validators) {
        this.capabilityDescriptorRegistry = (CapabilityDescriptorRegistry)Preconditions.checkNotNull((Object)capabilityDescriptorRegistry);
        this.capabilityFactoryRegistry = (CapabilityFactoryRegistry)Preconditions.checkNotNull((Object)capabilityFactoryRegistry);
        this.capabilityRegistry = (DefaultCapabilityRegistry)Preconditions.checkNotNull((Object)capabilityRegistry);
        this.validators = (Validators)Preconditions.checkNotNull((Object)validators);
    }

    @Override
    public Collection<Validator> get(CapabilityType type) {
        HashSet typeValidators = Sets.newHashSet();
        CapabilityDescriptor descriptor = this.capabilityDescriptorRegistry.get(type);
        if (descriptor != null) {
            CapabilityFactory factory;
            typeValidators.add(this.validators.capability().constraintsOf(type));
            Validator validator = descriptor.validator();
            if (validator != null) {
                typeValidators.add(validator);
            }
            if ((factory = this.capabilityFactoryRegistry.get(type)) != null && factory instanceof Validator) {
                typeValidators.add((Validator)((Object)factory));
            }
        }
        return typeValidators;
    }

    @Override
    public Collection<Validator> get(CapabilityIdentity id) {
        HashSet instanceValidators = Sets.newHashSet();
        DefaultCapabilityReference reference = this.capabilityRegistry.get(id);
        if (reference != null) {
            Validator validator;
            instanceValidators.add(this.validators.capability().constraintsOf(reference.context().type()));
            CapabilityDescriptor descriptor = this.capabilityDescriptorRegistry.get(reference.context().type());
            if (descriptor != null && (validator = descriptor.validator(id)) != null) {
                instanceValidators.add(validator);
            }
            if (reference.capability() instanceof Validator) {
                instanceValidators.add((Validator)((Object)reference.capability()));
            }
        }
        return instanceValidators;
    }
}

