/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.configuration.validation.ValidationMessage;
import org.sonatype.configuration.validation.ValidationResponse;
import org.sonatype.nexus.configuration.PasswordHelper;
import org.sonatype.nexus.formfields.Encrypted;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.plugins.capabilities.Capability;
import org.sonatype.nexus.plugins.capabilities.CapabilityDescriptor;
import org.sonatype.nexus.plugins.capabilities.CapabilityDescriptorRegistry;
import org.sonatype.nexus.plugins.capabilities.CapabilityEvent;
import org.sonatype.nexus.plugins.capabilities.CapabilityFactory;
import org.sonatype.nexus.plugins.capabilities.CapabilityFactoryRegistry;
import org.sonatype.nexus.plugins.capabilities.CapabilityIdentity;
import org.sonatype.nexus.plugins.capabilities.CapabilityNotFoundException;
import org.sonatype.nexus.plugins.capabilities.CapabilityReference;
import org.sonatype.nexus.plugins.capabilities.CapabilityRegistry;
import org.sonatype.nexus.plugins.capabilities.CapabilityRegistryEvent;
import org.sonatype.nexus.plugins.capabilities.CapabilityType;
import org.sonatype.nexus.plugins.capabilities.ValidationResult;
import org.sonatype.nexus.plugins.capabilities.Validator;
import org.sonatype.nexus.plugins.capabilities.ValidatorRegistry;
import org.sonatype.nexus.plugins.capabilities.internal.ActivationConditionHandlerFactory;
import org.sonatype.nexus.plugins.capabilities.internal.DefaultCapabilityReference;
import org.sonatype.nexus.plugins.capabilities.internal.ValidityConditionHandlerFactory;
import org.sonatype.nexus.plugins.capabilities.internal.storage.CapabilityStorage;
import org.sonatype.nexus.plugins.capabilities.internal.storage.CapabilityStorageItem;
import org.sonatype.plexus.components.cipher.PlexusCipherException;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Singleton
@Named
public class DefaultCapabilityRegistry
extends ComponentSupport
implements CapabilityRegistry {
    private final CapabilityStorage capabilityStorage;
    private final Provider<ValidatorRegistry> validatorRegistryProvider;
    private final CapabilityFactoryRegistry capabilityFactoryRegistry;
    private final CapabilityDescriptorRegistry capabilityDescriptorRegistry;
    private final EventBus eventBus;
    private final ActivationConditionHandlerFactory activationConditionHandlerFactory;
    private final ValidityConditionHandlerFactory validityConditionHandlerFactory;
    private final PasswordHelper passwordHelper;
    private final Map<CapabilityIdentity, DefaultCapabilityReference> references;
    private final ReentrantReadWriteLock lock;

    @Inject
    DefaultCapabilityRegistry(CapabilityStorage capabilityStorage, Provider<ValidatorRegistry> validatorRegistryProvider, CapabilityFactoryRegistry capabilityFactoryRegistry, CapabilityDescriptorRegistry capabilityDescriptorRegistry, EventBus eventBus, ActivationConditionHandlerFactory activationConditionHandlerFactory, ValidityConditionHandlerFactory validityConditionHandlerFactory, PasswordHelper passwordHelper) {
        this.capabilityStorage = (CapabilityStorage)Preconditions.checkNotNull((Object)capabilityStorage);
        this.validatorRegistryProvider = (Provider)Preconditions.checkNotNull(validatorRegistryProvider);
        this.capabilityFactoryRegistry = (CapabilityFactoryRegistry)Preconditions.checkNotNull((Object)capabilityFactoryRegistry);
        this.capabilityDescriptorRegistry = (CapabilityDescriptorRegistry)Preconditions.checkNotNull((Object)capabilityDescriptorRegistry);
        this.eventBus = (EventBus)Preconditions.checkNotNull((Object)eventBus);
        this.activationConditionHandlerFactory = (ActivationConditionHandlerFactory)Preconditions.checkNotNull((Object)activationConditionHandlerFactory);
        this.validityConditionHandlerFactory = (ValidityConditionHandlerFactory)Preconditions.checkNotNull((Object)validityConditionHandlerFactory);
        this.passwordHelper = (PasswordHelper)Preconditions.checkNotNull((Object)passwordHelper);
        this.references = new HashMap<CapabilityIdentity, DefaultCapabilityReference>();
        this.lock = new ReentrantReadWriteLock();
    }

    @Override
    public CapabilityReference add(CapabilityType type, boolean enabled, String notes, Map<String, String> properties) throws InvalidConfigurationException, IOException {
        try {
            this.lock.writeLock().lock();
            Map<Object, Object> props = properties == null ? Maps.newHashMap() : properties;
            this.validateType(type);
            this.validate(((ValidatorRegistry)Preconditions.checkNotNull((Object)((ValidatorRegistry)this.validatorRegistryProvider.get()))).get(type), props);
            CapabilityDescriptor descriptor = this.capabilityDescriptorRegistry.get(type);
            Map<String, String> encryptedProps = this.encryptValuesIfNeeded(descriptor, props);
            CapabilityIdentity generatedId = this.capabilityStorage.add(new CapabilityStorageItem(descriptor.version(), type.toString(), enabled, notes, encryptedProps));
            this.log.debug("Added capability '{}' of type '{}' with properties '{}'", new Object[]{generatedId, type, encryptedProps});
            DefaultCapabilityReference reference = this.create(generatedId, type, descriptor);
            reference.setNotes(notes);
            reference.create(props);
            if (enabled) {
                reference.enable();
                reference.activate();
            }
            DefaultCapabilityReference defaultCapabilityReference = reference;
            return defaultCapabilityReference;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public CapabilityReference update(CapabilityIdentity id, boolean enabled, String notes, Map<String, String> properties) throws InvalidConfigurationException, IOException {
        try {
            this.lock.writeLock().lock();
            Map<Object, Object> props = properties == null ? Maps.newHashMap() : properties;
            this.validateId(id);
            this.validate(((ValidatorRegistry)Preconditions.checkNotNull((Object)((ValidatorRegistry)this.validatorRegistryProvider.get()))).get(id), props);
            DefaultCapabilityReference reference = this.get(id);
            Map<String, String> encryptedProps = this.encryptValuesIfNeeded(reference.descriptor(), props);
            this.capabilityStorage.update(id, new CapabilityStorageItem(reference.descriptor().version(), reference.type().toString(), enabled, notes, encryptedProps));
            this.log.debug("Updated capability '{}' of type '{}' with properties '{}'", new Object[]{id, reference.type(), encryptedProps});
            if (reference.isEnabled() && !enabled) {
                reference.disable();
            }
            reference.setNotes(notes);
            reference.update(props, reference.properties());
            if (!reference.isEnabled() && enabled) {
                reference.enable();
                reference.activate();
            }
            DefaultCapabilityReference defaultCapabilityReference = reference;
            return defaultCapabilityReference;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public CapabilityReference remove(CapabilityIdentity id) throws IOException {
        try {
            this.lock.writeLock().lock();
            this.validateId(id);
            this.capabilityStorage.remove(id);
            this.log.debug("Removed capability with '{}'", (Object)id);
            DefaultCapabilityReference reference = this.references.remove(id);
            if (reference != null) {
                reference.remove();
            }
            DefaultCapabilityReference defaultCapabilityReference = reference;
            return defaultCapabilityReference;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public CapabilityReference enable(CapabilityIdentity id) throws IOException {
        try {
            this.lock.writeLock().lock();
            this.validateId(id);
            DefaultCapabilityReference reference = this.get(id);
            try {
                CapabilityReference capabilityReference = this.update(reference.context().id(), true, reference.notes(), reference.properties());
                return capabilityReference;
            }
            catch (InvalidConfigurationException e) {
                throw new RuntimeException("Unexpected", e);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public CapabilityReference disable(CapabilityIdentity id) throws IOException {
        try {
            this.lock.writeLock().lock();
            this.validateId(id);
            DefaultCapabilityReference reference = this.get(id);
            try {
                CapabilityReference capabilityReference = this.update(reference.context().id(), false, reference.notes(), reference.properties());
                return capabilityReference;
            }
            catch (InvalidConfigurationException e) {
                throw new RuntimeException("Unexpected", e);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public DefaultCapabilityReference get(CapabilityIdentity id) {
        try {
            this.lock.readLock().lock();
            DefaultCapabilityReference defaultCapabilityReference = this.references.get(id);
            return defaultCapabilityReference;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Collection<DefaultCapabilityReference> get(Predicate<CapabilityReference> filter) {
        return Collections.unmodifiableCollection(Collections2.filter(this.getAll(), filter));
    }

    public Collection<DefaultCapabilityReference> getAll() {
        try {
            this.lock.readLock().lock();
            Collection<DefaultCapabilityReference> collection = this.references.values();
            return collection;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void load() throws IOException {
        Map<CapabilityIdentity, CapabilityStorageItem> items = this.capabilityStorage.getAll();
        for (Map.Entry<CapabilityIdentity, CapabilityStorageItem> entry : items.entrySet()) {
            CapabilityIdentity id = entry.getKey();
            CapabilityStorageItem item = entry.getValue();
            this.log.debug("Loading capability '{}' of type '{}' with properties '{}'", new Object[]{id, item.getType(), item.getProperties()});
            CapabilityDescriptor descriptor = this.capabilityDescriptorRegistry.get(CapabilityType.capabilityType(item.getType()));
            if (descriptor == null) {
                this.log.warn("Capabilities persistent storage (capabilities.xml?) contains an capability of unknown type {} with id {}. This capability will not be loaded", (Object)item.getType(), (Object)id);
                continue;
            }
            Map<String, String> properties = this.decryptValuesIfNeeded(descriptor, item.getProperties());
            if (descriptor.version() != item.getVersion()) {
                block6: {
                    this.log.debug("Converting capability '{}' properties from version '{}' to version '{}'", new Object[]{id, item.getVersion(), descriptor.version()});
                    try {
                        properties = descriptor.convert(properties, item.getVersion());
                        if (properties == null) {
                            properties = Collections.emptyMap();
                        }
                        if (!this.log.isDebugEnabled()) break block6;
                        this.log.debug("Converted capability '{}' properties '{}' (version '{}') to '{}' (version '{}')", new Object[]{id, item.getProperties(), item.getVersion(), this.encryptValuesIfNeeded(descriptor, properties), descriptor.version()});
                    }
                    catch (Exception e) {
                        this.log.error("Failed converting capability '{}' properties '{}' from version '{}' to version '{}'. Capability will not be loaded", new Object[]{id, item.getProperties(), item.getVersion(), descriptor.version(), e});
                        continue;
                    }
                }
                this.capabilityStorage.update(id, new CapabilityStorageItem(descriptor.version(), item.getType(), item.isEnabled(), item.getNotes(), properties));
            }
            DefaultCapabilityReference reference = this.create(id, CapabilityType.capabilityType(item.getType()), descriptor);
            reference.setNotes(item.getNotes());
            reference.load(properties);
            if (!item.isEnabled()) continue;
            reference.enable();
            reference.activate();
        }
        this.eventBus.post((Object)new CapabilityRegistryEvent.AfterLoad(this));
    }

    private DefaultCapabilityReference create(CapabilityIdentity id, CapabilityType type, CapabilityDescriptor descriptor) {
        CapabilityFactory factory = this.capabilityFactoryRegistry.get(type);
        if (factory == null) {
            throw new RuntimeException(String.format("No factory found for a capability of type %s", type));
        }
        Capability capability = factory.create();
        DefaultCapabilityReference reference = this.createReference(id, type, descriptor, capability);
        this.references.put(id, reference);
        this.log.debug("Created capability '{}'", (Object)capability);
        this.eventBus.post((Object)new CapabilityEvent.Created(this, reference));
        return reference;
    }

    @VisibleForTesting
    DefaultCapabilityReference createReference(CapabilityIdentity id, CapabilityType type, CapabilityDescriptor descriptor, Capability capability) {
        return new DefaultCapabilityReference(this, this.eventBus, this.activationConditionHandlerFactory, this.validityConditionHandlerFactory, id, type, descriptor, capability);
    }

    private void validateType(CapabilityType type) throws InvalidConfigurationException {
        ValidationResponse vr = new ValidationResponse();
        if (type == null) {
            vr.addValidationError(new ValidationMessage("typeId", "Type must be provided"));
        } else if (this.capabilityFactoryRegistry.get(type) == null || this.capabilityDescriptorRegistry.get(type) == null) {
            vr.addValidationError(new ValidationMessage("typeId", "Type '" + type + "' is not supported"));
        }
        if (vr.getValidationErrors().size() > 0) {
            throw new InvalidConfigurationException(vr);
        }
    }

    private void validateId(CapabilityIdentity id) throws CapabilityNotFoundException {
        if (this.get(id) == null) {
            throw new CapabilityNotFoundException(id);
        }
    }

    private void validate(Collection<Validator> validators, Map<String, String> properties) throws InvalidConfigurationException {
        if (validators != null && !validators.isEmpty()) {
            ValidationResponse vr = new ValidationResponse();
            for (Validator validator : validators) {
                ValidationResult validationResult = validator.validate(properties);
                if (validationResult.isValid()) continue;
                for (ValidationResult.Violation violation : validationResult.violations()) {
                    vr.addValidationError(new ValidationMessage(violation.key(), violation.message()));
                }
            }
            if (vr.getValidationErrors().size() > 0) {
                throw new InvalidConfigurationException(vr);
            }
        }
    }

    private Map<String, String> encryptValuesIfNeeded(CapabilityDescriptor descriptor, Map<String, String> props) throws IOException {
        if (props == null || props.isEmpty()) {
            return props;
        }
        HashMap encrypted = Maps.newHashMap(props);
        List<FormField> formFields = descriptor.formFields();
        if (formFields != null) {
            for (FormField formField : formFields) {
                String value;
                if (!(formField instanceof Encrypted) || (value = (String)encrypted.get(formField.getId())) == null) continue;
                try {
                    encrypted.put(formField.getId(), this.passwordHelper.encrypt(value));
                }
                catch (PlexusCipherException e) {
                    throw new IOException("Could not encrypt value of '" + formField.getType() + "' due to " + e.getMessage(), e);
                }
            }
        }
        return encrypted;
    }

    private Map<String, String> decryptValuesIfNeeded(CapabilityDescriptor descriptor, Map<String, String> props) throws IOException {
        if (props == null || props.isEmpty()) {
            return props;
        }
        HashMap decrypted = Maps.newHashMap(props);
        List<FormField> formFields = descriptor.formFields();
        if (formFields != null) {
            for (FormField formField : formFields) {
                String value;
                if (!(formField instanceof Encrypted) || (value = (String)decrypted.get(formField.getId())) == null) continue;
                try {
                    decrypted.put(formField.getId(), this.passwordHelper.decrypt(value));
                }
                catch (PlexusCipherException e) {
                    throw new IOException("Could not decrypt value of '" + formField.getType() + "' due to " + e.getMessage(), e);
                }
            }
        }
        return decrypted;
    }
}

