/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.sonatype.nexus.plugins.capabilities.Capability;
import org.sonatype.nexus.plugins.capabilities.CapabilityContext;
import org.sonatype.nexus.plugins.capabilities.CapabilityDescriptor;
import org.sonatype.nexus.plugins.capabilities.CapabilityEvent;
import org.sonatype.nexus.plugins.capabilities.CapabilityIdentity;
import org.sonatype.nexus.plugins.capabilities.CapabilityReference;
import org.sonatype.nexus.plugins.capabilities.CapabilityRegistry;
import org.sonatype.nexus.plugins.capabilities.CapabilityType;
import org.sonatype.nexus.plugins.capabilities.internal.ActivationConditionHandler;
import org.sonatype.nexus.plugins.capabilities.internal.ActivationConditionHandlerFactory;
import org.sonatype.nexus.plugins.capabilities.internal.ValidityConditionHandler;
import org.sonatype.nexus.plugins.capabilities.internal.ValidityConditionHandlerFactory;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.goodies.eventbus.EventBus;

public class DefaultCapabilityReference
extends ComponentSupport
implements CapabilityReference,
CapabilityContext {
    private static final Map<String, String> EMPTY_MAP = Collections.emptyMap();
    private final CapabilityIdentity id;
    private final CapabilityType type;
    private final CapabilityDescriptor descriptor;
    private final Capability capability;
    private String notes;
    private final CapabilityRegistry capabilityRegistry;
    private final EventBus eventBus;
    private final ActivationConditionHandler activationHandler;
    private final ValidityConditionHandler validityHandler;
    private final ReentrantReadWriteLock stateLock;
    private Map<String, String> capabilityProperties;
    private State state;
    private Exception failure;
    private String failingAction;

    DefaultCapabilityReference(CapabilityRegistry capabilityRegistry, EventBus eventBus, ActivationConditionHandlerFactory activationListenerFactory, ValidityConditionHandlerFactory validityConditionHandlerFactory, CapabilityIdentity id, CapabilityType type, CapabilityDescriptor descriptor, Capability capability) {
        this.capabilityRegistry = (CapabilityRegistry)Preconditions.checkNotNull((Object)capabilityRegistry);
        this.eventBus = (EventBus)Preconditions.checkNotNull((Object)eventBus);
        this.id = (CapabilityIdentity)Preconditions.checkNotNull((Object)id);
        this.type = (CapabilityType)Preconditions.checkNotNull((Object)type);
        this.descriptor = (CapabilityDescriptor)Preconditions.checkNotNull((Object)descriptor);
        this.capability = (Capability)Preconditions.checkNotNull((Object)capability);
        this.capabilityProperties = EMPTY_MAP;
        this.state = new NewState();
        this.stateLock = new ReentrantReadWriteLock();
        this.activationHandler = ((ActivationConditionHandlerFactory)Preconditions.checkNotNull((Object)activationListenerFactory)).create(this);
        this.validityHandler = ((ValidityConditionHandlerFactory)Preconditions.checkNotNull((Object)validityConditionHandlerFactory)).create(this);
        capability.init(this);
    }

    @Override
    public Capability capability() {
        return this.capability;
    }

    @Override
    public <T extends Capability> T capabilityAs(Class<T> type) {
        return (T)this.capability;
    }

    @Override
    public CapabilityIdentity id() {
        return this.id;
    }

    @Override
    public CapabilityType type() {
        return this.type;
    }

    @Override
    public CapabilityDescriptor descriptor() {
        return this.descriptor;
    }

    @Override
    public String notes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    @Override
    public boolean isEnabled() {
        try {
            this.stateLock.readLock().lock();
            boolean bl = this.state.isEnabled();
            return bl;
        }
        finally {
            this.stateLock.readLock().unlock();
        }
    }

    public void enable() {
        try {
            this.stateLock.writeLock().lock();
            this.state.enable();
        }
        finally {
            this.stateLock.writeLock().unlock();
        }
    }

    public void disable() {
        try {
            this.stateLock.writeLock().lock();
            this.state.disable();
        }
        finally {
            this.stateLock.writeLock().unlock();
        }
    }

    @Override
    public boolean isActive() {
        try {
            this.stateLock.readLock().lock();
            boolean bl = this.state.isActive();
            return bl;
        }
        finally {
            this.stateLock.readLock().unlock();
        }
    }

    @Override
    public boolean hasFailure() {
        return this.failure() != null;
    }

    @Override
    public Exception failure() {
        try {
            this.stateLock.readLock().lock();
            Exception exception = this.failure;
            return exception;
        }
        finally {
            this.stateLock.readLock().unlock();
        }
    }

    @Override
    public String failingAction() {
        try {
            this.stateLock.readLock().lock();
            String string = this.failingAction;
            return string;
        }
        finally {
            this.stateLock.readLock().unlock();
        }
    }

    public void activate() {
        try {
            this.stateLock.writeLock().lock();
            this.state.activate();
        }
        finally {
            this.stateLock.writeLock().unlock();
        }
    }

    public void passivate() {
        try {
            this.stateLock.writeLock().lock();
            this.state.passivate();
        }
        finally {
            this.stateLock.writeLock().unlock();
        }
    }

    @Override
    public CapabilityContext context() {
        return this;
    }

    public void create(Map<String, String> properties) {
        try {
            this.stateLock.writeLock().lock();
            this.state.create(properties);
        }
        finally {
            this.stateLock.writeLock().unlock();
        }
    }

    public void load(Map<String, String> properties) {
        try {
            this.stateLock.writeLock().lock();
            this.state.load(properties);
        }
        finally {
            this.stateLock.writeLock().unlock();
        }
    }

    public void update(Map<String, String> properties, Map<String, String> previousProperties) {
        if (!DefaultCapabilityReference.sameProperties(previousProperties, properties)) {
            try {
                this.stateLock.writeLock().lock();
                this.state.update(properties, previousProperties);
            }
            finally {
                this.stateLock.writeLock().unlock();
            }
        }
    }

    public void remove() {
        try {
            this.stateLock.writeLock().lock();
            this.state.remove();
        }
        finally {
            this.stateLock.writeLock().unlock();
        }
    }

    @Override
    public Map<String, String> properties() {
        try {
            this.stateLock.readLock().lock();
            Map<String, String> map = this.capabilityProperties;
            return map;
        }
        finally {
            this.stateLock.readLock().unlock();
        }
    }

    @Override
    public String stateDescription() {
        try {
            this.stateLock.readLock().lock();
            String string = this.state.stateDescription();
            return string;
        }
        finally {
            this.stateLock.readLock().unlock();
        }
    }

    public String toString() {
        return String.format("capability %s (enabled=%s, active=%s)", this.capability, this.isEnabled(), this.isActive());
    }

    static boolean sameProperties(Map<String, String> p1, Map<String, String> p2) {
        if (p1 == null) {
            return p2 == null;
        }
        if (p2 == null) {
            return false;
        }
        return p1.size() == p2.size() && p1.equals(p2);
    }

    private void resetFailure() {
        try {
            this.stateLock.writeLock().lock();
            if (this.failure != null) {
                this.failure = null;
                this.failingAction = null;
                this.eventBus.post((Object)new CapabilityEvent.CallbackFailureCleared(this.capabilityRegistry, this));
            }
        }
        finally {
            this.stateLock.writeLock().unlock();
        }
    }

    private void setFailure(String action, Exception e) {
        try {
            this.stateLock.writeLock().lock();
            this.failure = (Exception)Preconditions.checkNotNull((Object)e);
            this.failingAction = (String)Preconditions.checkNotNull((Object)action);
            this.log.error("Could not {} capability {} ({})", new Object[]{action.toLowerCase(), this.capability, this.id, e});
            this.eventBus.post((Object)new CapabilityEvent.CallbackFailure(this.capabilityRegistry, this, action, e));
        }
        finally {
            this.stateLock.writeLock().unlock();
        }
    }

    private class ActiveState
    extends EnabledState {
        private ActiveState() {
            super(null, null);
        }

        @Override
        public boolean isActive() {
            return true;
        }

        @Override
        public void activate() {
        }

        @Override
        public void passivate() {
            DefaultCapabilityReference.this.log.debug("Passivating capability {} ({})", (Object)DefaultCapabilityReference.this.capability, (Object)DefaultCapabilityReference.this.id);
            try {
                DefaultCapabilityReference.this.state = new EnabledState();
                DefaultCapabilityReference.this.eventBus.post((Object)new CapabilityEvent.BeforePassivated(DefaultCapabilityReference.this.capabilityRegistry, DefaultCapabilityReference.this));
                DefaultCapabilityReference.this.capability.onPassivate();
                DefaultCapabilityReference.this.log.debug("Passivated capability {} ({})", (Object)DefaultCapabilityReference.this.capability, (Object)DefaultCapabilityReference.this.id);
            }
            catch (Exception e) {
                DefaultCapabilityReference.this.setFailure("Passivate", e);
            }
        }

        @Override
        public String stateDescription() {
            return "Active";
        }

        @Override
        public String toString() {
            return "ACTIVE";
        }
    }

    private class DisabledState
    extends State {
        private DisabledState() {
        }

        @Override
        public void enable() {
            DefaultCapabilityReference.this.log.debug("Enabling capability {} ({})", (Object)DefaultCapabilityReference.this.capability, (Object)DefaultCapabilityReference.this.id);
            DefaultCapabilityReference.this.state = new EnabledState();
            DefaultCapabilityReference.this.activationHandler.bind();
        }

        @Override
        public void disable() {
        }

        @Override
        public void passivate() {
        }

        @Override
        public void update(Map<String, String> properties, Map<String, String> previousProperties) {
            try {
                try {
                    DefaultCapabilityReference.this.eventBus.post((Object)new CapabilityEvent.BeforeUpdate(DefaultCapabilityReference.this.capabilityRegistry, DefaultCapabilityReference.this, properties, previousProperties));
                    DefaultCapabilityReference.this.capabilityProperties = properties == null ? EMPTY_MAP : Collections.unmodifiableMap(Maps.newHashMap(properties));
                    DefaultCapabilityReference.this.capability.onUpdate();
                    DefaultCapabilityReference.this.resetFailure();
                }
                catch (Exception e) {
                    DefaultCapabilityReference.this.setFailure("Update", e);
                    DefaultCapabilityReference.this.eventBus.post((Object)new CapabilityEvent.AfterUpdate(DefaultCapabilityReference.this.capabilityRegistry, DefaultCapabilityReference.this, properties, previousProperties));
                }
            }
            finally {
                DefaultCapabilityReference.this.eventBus.post((Object)new CapabilityEvent.AfterUpdate(DefaultCapabilityReference.this.capabilityRegistry, DefaultCapabilityReference.this, properties, previousProperties));
            }
        }

        @Override
        public void remove() {
            try {
                try {
                    DefaultCapabilityReference.this.disable();
                    DefaultCapabilityReference.this.validityHandler.release();
                    DefaultCapabilityReference.this.capability.onRemove();
                    DefaultCapabilityReference.this.resetFailure();
                }
                catch (Exception e) {
                    DefaultCapabilityReference.this.setFailure("Remove", e);
                    DefaultCapabilityReference.this.state = new RemovedState();
                    DefaultCapabilityReference.this.eventBus.post((Object)new CapabilityEvent.AfterRemove(DefaultCapabilityReference.this.capabilityRegistry, DefaultCapabilityReference.this));
                }
            }
            finally {
                DefaultCapabilityReference.this.state = new RemovedState();
                DefaultCapabilityReference.this.eventBus.post((Object)new CapabilityEvent.AfterRemove(DefaultCapabilityReference.this.capabilityRegistry, DefaultCapabilityReference.this));
            }
        }

        @Override
        public String stateDescription() {
            return "Disabled";
        }

        @Override
        public String toString() {
            return "DISABLED";
        }

        /* synthetic */ DisabledState(DisabledState disabledState, DisabledState disabledState2) {
            this();
        }
    }

    private class EnabledState
    extends DisabledState {
        private EnabledState() {
            super(null, null);
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void enable() {
        }

        @Override
        public void disable() {
            DefaultCapabilityReference.this.log.debug("Disabling capability {} ({})", (Object)DefaultCapabilityReference.this.capability, (Object)DefaultCapabilityReference.this.id);
            DefaultCapabilityReference.this.activationHandler.release();
            DefaultCapabilityReference.this.passivate();
            DefaultCapabilityReference.this.state = new DisabledState();
        }

        @Override
        public void activate() {
            if (DefaultCapabilityReference.this.activationHandler.isConditionSatisfied()) {
                DefaultCapabilityReference.this.log.debug("Activating capability {} ({})", (Object)DefaultCapabilityReference.this.capability, (Object)DefaultCapabilityReference.this.id);
                try {
                    DefaultCapabilityReference.this.capability.onActivate();
                    DefaultCapabilityReference.this.resetFailure();
                    DefaultCapabilityReference.this.log.debug("Activated capability {} ({})", (Object)DefaultCapabilityReference.this.capability, (Object)DefaultCapabilityReference.this.id);
                    DefaultCapabilityReference.this.state = new ActiveState();
                    DefaultCapabilityReference.this.eventBus.post((Object)new CapabilityEvent.AfterActivated(DefaultCapabilityReference.this.capabilityRegistry, DefaultCapabilityReference.this));
                }
                catch (Exception e) {
                    DefaultCapabilityReference.this.setFailure("Activate", e);
                }
            } else {
                DefaultCapabilityReference.this.log.debug("Capability {} ({}) is not yet activatable", (Object)DefaultCapabilityReference.this.capability, (Object)DefaultCapabilityReference.this.id);
            }
        }

        @Override
        public void passivate() {
        }

        @Override
        public String stateDescription() {
            return DefaultCapabilityReference.this.activationHandler.isConditionSatisfied() ? "Enabled" : DefaultCapabilityReference.this.activationHandler.explainWhyNotSatisfied();
        }

        @Override
        public String toString() {
            return "ENABLED";
        }

        /* synthetic */ EnabledState(EnabledState enabledState, EnabledState enabledState2) {
            this();
        }
    }

    private class NewState
    extends State {
        private NewState() {
        }

        @Override
        public void create(Map<String, String> properties) {
            try {
                try {
                    DefaultCapabilityReference.this.capabilityProperties = properties == null ? EMPTY_MAP : Collections.unmodifiableMap(Maps.newHashMap(properties));
                    DefaultCapabilityReference.this.capability.onCreate();
                    DefaultCapabilityReference.this.resetFailure();
                }
                catch (Exception e) {
                    DefaultCapabilityReference.this.setFailure("Create", e);
                    DefaultCapabilityReference.this.validityHandler.bind();
                    DefaultCapabilityReference.this.state = new DisabledState();
                }
            }
            finally {
                DefaultCapabilityReference.this.validityHandler.bind();
                DefaultCapabilityReference.this.state = new DisabledState();
            }
        }

        @Override
        public void load(Map<String, String> properties) {
            try {
                try {
                    DefaultCapabilityReference.this.capabilityProperties = properties == null ? EMPTY_MAP : Collections.unmodifiableMap(Maps.newHashMap(properties));
                    DefaultCapabilityReference.this.capability.onLoad();
                    DefaultCapabilityReference.this.resetFailure();
                }
                catch (Exception e) {
                    DefaultCapabilityReference.this.setFailure("Load", e);
                    DefaultCapabilityReference.this.validityHandler.bind();
                    DefaultCapabilityReference.this.state = new DisabledState();
                }
            }
            finally {
                DefaultCapabilityReference.this.validityHandler.bind();
                DefaultCapabilityReference.this.state = new DisabledState();
            }
        }

        @Override
        public String stateDescription() {
            return "New";
        }

        @Override
        public String toString() {
            return "NEW";
        }
    }

    public class RemovedState
    extends State {
        @Override
        public String stateDescription() {
            return "Removed";
        }

        @Override
        public String toString() {
            return "REMOVED";
        }
    }

    private class State {
        State() {
            DefaultCapabilityReference.this.log.debug("Capability {} ({}) state changed to {}", new Object[]{DefaultCapabilityReference.this.capability, DefaultCapabilityReference.this.id, this});
        }

        public boolean isEnabled() {
            return false;
        }

        public void enable() {
            throw new IllegalStateException("State '" + this.toString() + "' does not permit 'enable' operation");
        }

        public void disable() {
            throw new IllegalStateException("State '" + this.toString() + "' does not permit 'disable' operation");
        }

        public boolean isActive() {
            return false;
        }

        public void activate() {
            throw new IllegalStateException("State '" + this.toString() + "' does not permit 'activate' operation");
        }

        public void passivate() {
            throw new IllegalStateException("State '" + this.toString() + "' does not permit 'passivate' operation");
        }

        public void create(Map<String, String> properties) {
            throw new IllegalStateException("State '" + this.toString() + "' does not permit 'create' operation");
        }

        public void load(Map<String, String> properties) {
            throw new IllegalStateException("State '" + this.toString() + "' does not permit 'load' operation");
        }

        public void update(Map<String, String> properties, Map<String, String> previousProperties) {
            throw new IllegalStateException("State '" + this.toString() + "' does not permit 'update' operation");
        }

        public void remove() {
            throw new IllegalStateException("State '" + this.toString() + "' does not permit 'remove' operation");
        }

        public String stateDescription() {
            return "Undefined";
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }
}

