/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities.internal;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Provider;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.sisu.EagerSingleton;
import org.sonatype.nexus.plugins.capabilities.internal.DefaultCapabilityRegistry;
import org.sonatype.nexus.plugins.capabilities.internal.storage.CapabilityStorage;
import org.sonatype.nexus.plugins.capabilities.internal.storage.KazukiCapabilityStorageConverter;
import org.sonatype.nexus.proxy.events.NexusInitializedEvent;
import org.sonatype.nexus.proxy.events.NexusStoppingEvent;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Named
@EagerSingleton
public class CapabilityRegistryBooter {
    private final Provider<DefaultCapabilityRegistry> capabilityRegistry;
    private final Provider<CapabilityStorage> capabilityStorage;
    private final Provider<KazukiCapabilityStorageConverter> storageConverter;

    @Inject
    public CapabilityRegistryBooter(EventBus eventBus, Provider<DefaultCapabilityRegistry> capabilityRegistry, Provider<CapabilityStorage> capabilityStorage, Provider<KazukiCapabilityStorageConverter> storageConverter) {
        this.capabilityRegistry = capabilityRegistry;
        this.capabilityStorage = (Provider)Preconditions.checkNotNull(capabilityStorage);
        this.storageConverter = (Provider)Preconditions.checkNotNull(storageConverter);
        ((EventBus)Preconditions.checkNotNull((Object)eventBus)).register((Object)this);
    }

    @Subscribe
    public void handle(NexusInitializedEvent event) {
        try {
            ((CapabilityStorage)this.capabilityStorage.get()).start();
            ((KazukiCapabilityStorageConverter)((Object)this.storageConverter.get())).maybeConvert();
            ((DefaultCapabilityRegistry)this.capabilityRegistry.get()).load();
        }
        catch (Exception e) {
            throw new Error("Could not boot capabilities", e);
        }
    }

    @Subscribe
    public void handle(NexusStoppingEvent event) {
        try {
            ((CapabilityStorage)this.capabilityStorage.get()).stop();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not shutdown", e);
        }
    }

    public String toString() {
        return "Load capabilities from persistence store when Nexus is initialized";
    }
}

