/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities.internal;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.google.inject.assistedinject.Assisted;
import javax.inject.Inject;
import org.sonatype.nexus.plugins.capabilities.CapabilityContextAware;
import org.sonatype.nexus.plugins.capabilities.Condition;
import org.sonatype.nexus.plugins.capabilities.ConditionEvent;
import org.sonatype.nexus.plugins.capabilities.internal.DefaultCapabilityReference;
import org.sonatype.nexus.plugins.capabilities.internal.condition.SatisfiedCondition;
import org.sonatype.nexus.plugins.capabilities.internal.condition.UnsatisfiedCondition;
import org.sonatype.nexus.plugins.capabilities.support.condition.Conditions;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.goodies.eventbus.EventBus;

public class ActivationConditionHandler
extends ComponentSupport {
    private final EventBus eventBus;
    private final DefaultCapabilityReference reference;
    private final Conditions conditions;
    private Condition activationCondition;

    @Inject
    ActivationConditionHandler(EventBus eventBus, Conditions conditions, @Assisted DefaultCapabilityReference reference) {
        this.eventBus = (EventBus)Preconditions.checkNotNull((Object)eventBus);
        this.conditions = (Conditions)Preconditions.checkNotNull((Object)conditions);
        this.reference = (DefaultCapabilityReference)Preconditions.checkNotNull((Object)reference);
    }

    boolean isConditionSatisfied() {
        return this.activationCondition != null && this.activationCondition.isSatisfied();
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(ConditionEvent.Satisfied event) {
        if (event.getCondition() == this.activationCondition) {
            this.reference.activate();
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(ConditionEvent.Unsatisfied event) {
        if (event.getCondition() == this.activationCondition) {
            this.reference.passivate();
        }
    }

    ActivationConditionHandler bind() {
        if (this.activationCondition == null) {
            try {
                Condition capabilityActivationCondition = this.reference.capability().activationCondition();
                if (capabilityActivationCondition == null) {
                    capabilityActivationCondition = new SatisfiedCondition("Capability has no activation condition");
                }
                this.activationCondition = this.conditions.logical().and(capabilityActivationCondition, this.conditions.nexus().active(), this.conditions.capabilities().capabilityHasNoFailures());
                if (this.activationCondition instanceof CapabilityContextAware) {
                    ((CapabilityContextAware)((Object)this.activationCondition)).setContext(this.reference.context());
                }
            }
            catch (Exception e) {
                this.activationCondition = new UnsatisfiedCondition("Failed to determine activation condition");
                this.log.error("Could not get activation condition from capability {} ({}). Considering it as non activatable", new Object[]{this.reference.capability(), this.reference.context().id(), e});
            }
            this.activationCondition.bind();
            this.eventBus.register((Object)this);
        }
        return this;
    }

    ActivationConditionHandler release() {
        if (this.activationCondition != null) {
            this.eventBus.unregister((Object)this);
            this.activationCondition.release();
            this.activationCondition = null;
        }
        return this;
    }

    public String toString() {
        return String.format("Watching '%s' condition to activate/passivate capability '%s (id=%s)'", this.activationCondition, this.reference.capability(), this.reference.context().id());
    }

    public String explainWhyNotSatisfied() {
        return this.isConditionSatisfied() ? null : this.activationCondition.explainUnsatisfied();
    }
}

