/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.sonatype.nexus.events.AbstractEvent;
import org.sonatype.nexus.plugins.capabilities.CapabilityReference;
import org.sonatype.nexus.plugins.capabilities.CapabilityRegistry;

public class CapabilityEvent
extends AbstractEvent<CapabilityRegistry> {
    private final CapabilityReference reference;

    public CapabilityEvent(CapabilityRegistry capabilityRegistry, CapabilityReference reference) {
        super((Object)((CapabilityRegistry)Preconditions.checkNotNull((Object)capabilityRegistry)));
        this.reference = (CapabilityReference)Preconditions.checkNotNull((Object)reference);
    }

    public CapabilityReference getReference() {
        return this.reference;
    }

    public String toString() {
        return this.getReference().toString();
    }

    public static class AfterActivated
    extends CapabilityEvent {
        public AfterActivated(CapabilityRegistry capabilityRegistry, CapabilityReference reference) {
            super(capabilityRegistry, reference);
        }

        @Override
        public String toString() {
            return "Activated " + super.toString();
        }
    }

    public static class AfterRemove
    extends CapabilityEvent {
        public AfterRemove(CapabilityRegistry capabilityRegistry, CapabilityReference reference) {
            super(capabilityRegistry, reference);
        }

        @Override
        public String toString() {
            return "After remove of " + super.toString();
        }
    }

    public static class AfterUpdate
    extends CapabilityEvent {
        private final Map<String, String> properties;
        private final Map<String, String> previousProperties;

        public AfterUpdate(CapabilityRegistry capabilityRegistry, CapabilityReference reference, Map<String, String> properties, Map<String, String> previousProperties) {
            super(capabilityRegistry, reference);
            this.properties = (Map)Preconditions.checkNotNull(properties);
            this.previousProperties = (Map)Preconditions.checkNotNull(previousProperties);
        }

        @Override
        public String toString() {
            return "After update of " + super.toString();
        }

        public Map<String, String> properties() {
            return this.properties;
        }

        public Map<String, String> previousProperties() {
            return this.previousProperties;
        }
    }

    public static class BeforePassivated
    extends CapabilityEvent {
        public BeforePassivated(CapabilityRegistry capabilityRegistry, CapabilityReference reference) {
            super(capabilityRegistry, reference);
        }

        @Override
        public String toString() {
            return "Passivated " + super.toString();
        }
    }

    public static class BeforeUpdate
    extends CapabilityEvent {
        private final Map<String, String> properties;
        private final Map<String, String> previousProperties;

        public BeforeUpdate(CapabilityRegistry capabilityRegistry, CapabilityReference reference, Map<String, String> properties, Map<String, String> previousProperties) {
            super(capabilityRegistry, reference);
            this.properties = (Map)Preconditions.checkNotNull(properties);
            this.previousProperties = (Map)Preconditions.checkNotNull(previousProperties);
        }

        @Override
        public String toString() {
            return "Before update of " + super.toString();
        }

        public Map<String, String> properties() {
            return this.properties;
        }

        public Map<String, String> previousProperties() {
            return this.previousProperties;
        }
    }

    public static class CallbackFailure
    extends CapabilityEvent {
        private String failingAction;
        private Exception failure;

        public CallbackFailure(CapabilityRegistry capabilityRegistry, CapabilityReference reference, String failingAction, Exception failure) {
            super(capabilityRegistry, reference);
            this.failingAction = (String)Preconditions.checkNotNull((Object)failingAction, (Object)"failingAction");
            this.failure = (Exception)Preconditions.checkNotNull((Object)failure, (Object)"failure");
        }

        @Override
        public String toString() {
            return String.valueOf(this.failingAction) + " Failed " + super.toString();
        }

        public Exception failure() {
            return this.failure;
        }

        public String failingAction() {
            return this.failingAction;
        }
    }

    public static class CallbackFailureCleared
    extends CapabilityEvent {
        public CallbackFailureCleared(CapabilityRegistry capabilityRegistry, CapabilityReference reference) {
            super(capabilityRegistry, reference);
        }

        @Override
        public String toString() {
            return "Error cleared " + super.toString();
        }
    }

    public static class Created
    extends CapabilityEvent {
        public Created(CapabilityRegistry capabilityRegistry, CapabilityReference reference) {
            super(capabilityRegistry, reference);
        }

        @Override
        public String toString() {
            return "Created " + super.toString();
        }
    }
}

