/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.capability.support;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Provider;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.plugins.capabilities.CapabilityDescriptor;
import org.sonatype.nexus.plugins.capabilities.CapabilityDescriptorRegistry;
import org.sonatype.nexus.plugins.capabilities.CapabilityType;

public abstract class ValidatorSupport {
    private final Provider<CapabilityDescriptorRegistry> capabilityDescriptorRegistryProvider;
    private final CapabilityType type;

    protected ValidatorSupport(Provider<CapabilityDescriptorRegistry> capabilityDescriptorRegistryProvider, CapabilityType type) {
        this.capabilityDescriptorRegistryProvider = (Provider)Preconditions.checkNotNull(capabilityDescriptorRegistryProvider);
        this.type = (CapabilityType)Preconditions.checkNotNull((Object)type);
    }

    protected CapabilityDescriptorRegistry capabilityDescriptorRegistry() {
        return (CapabilityDescriptorRegistry)this.capabilityDescriptorRegistryProvider.get();
    }

    protected CapabilityType capabilityType() {
        return this.type;
    }

    protected CapabilityDescriptor capabilityDescriptor() {
        return this.capabilityDescriptorRegistry().get(this.type);
    }

    protected String typeName() {
        CapabilityDescriptor descriptor = this.capabilityDescriptor();
        if (descriptor != null) {
            return descriptor.name();
        }
        return this.capabilityType().toString();
    }

    protected String propertyName(String propertyKey) {
        String name = this.extractNames().get(propertyKey);
        if (name == null) {
            name = propertyKey;
        }
        return name;
    }

    private Map<String, String> extractNames() {
        HashMap keyToName = Maps.newHashMap();
        List<FormField> formFields = this.capabilityDescriptor().formFields();
        if (formFields != null) {
            for (FormField formField : formFields) {
                keyToName.put(formField.getId(), formField.getLabel());
            }
        }
        return keyToName;
    }
}

