/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.capability.support;

import com.google.common.base.Preconditions;
import java.net.URL;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.sonatype.nexus.plugins.capabilities.Capability;
import org.sonatype.nexus.plugins.capabilities.CapabilityContext;
import org.sonatype.nexus.plugins.capabilities.Condition;
import org.sonatype.nexus.plugins.capabilities.support.condition.Conditions;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.goodies.i18n.I18N;
import org.sonatype.sisu.goodies.i18n.MessageBundle;
import org.sonatype.sisu.goodies.template.TemplateEngine;
import org.sonatype.sisu.goodies.template.TemplateParameters;
import org.sonatype.sisu.goodies.template.TemplateThrowableAdapter;

public abstract class CapabilitySupport<ConfigT>
extends ComponentSupport
implements Capability {
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private CapabilityContext context;
    private ConfigT config;
    private Conditions conditions;
    private TemplateEngine templateEngine;

    @Override
    public void init(CapabilityContext context) {
        this.context = (CapabilityContext)Preconditions.checkNotNull((Object)context);
    }

    protected CapabilityContext context() {
        return this.context;
    }

    @Override
    public String status() {
        if (this.context.hasFailure()) {
            return this.renderFailure(this.context.failure());
        }
        try {
            return this.renderStatus();
        }
        catch (Exception e) {
            this.log.warn("Failed to render status", (Throwable)e);
            return null;
        }
    }

    protected String renderStatus() throws Exception {
        return null;
    }

    @Override
    public String description() {
        if (this.context.hasFailure()) {
            return messages.failure(this.context.failure().getClass().getName());
        }
        try {
            return this.renderDescription();
        }
        catch (Exception e) {
            this.log.warn("Failed to render description", (Throwable)e);
            return null;
        }
    }

    protected String renderDescription() throws Exception {
        return null;
    }

    protected boolean isConfigured() {
        return this.config != null;
    }

    protected void ensureConfigured() {
        Preconditions.checkState((this.config != null ? 1 : 0) != 0, (Object)"Capability is not configured");
    }

    protected abstract ConfigT createConfig(Map<String, String> var1) throws Exception;

    public ConfigT getConfig() {
        this.ensureConfigured();
        return this.config;
    }

    protected void configure(ConfigT config) throws Exception {
    }

    private void logLifecycle(@NonNls String msg, ConfigT config) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("{}: {}", (Object)msg, config);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug(msg);
        }
    }

    @Override
    public void onCreate() throws Exception {
        Preconditions.checkState((this.config == null ? 1 : 0) != 0);
        this.config = this.createConfig(this.context().properties());
        this.logLifecycle("Creating", this.config);
        this.onCreate(this.config);
    }

    protected void onCreate(ConfigT config) throws Exception {
        this.configure(config);
    }

    @Override
    public void onLoad() throws Exception {
        Preconditions.checkState((this.config == null ? 1 : 0) != 0);
        this.config = this.createConfig(this.context().properties());
        this.logLifecycle("Loading", this.config);
        this.onLoad(this.config);
    }

    protected void onLoad(ConfigT config) throws Exception {
        this.configure(config);
    }

    @Override
    public void onUpdate() throws Exception {
        this.config = this.createConfig(this.context().properties());
        this.logLifecycle("Updating", this.config);
        this.onUpdate(this.config);
    }

    protected void onUpdate(ConfigT config) throws Exception {
        this.configure(config);
    }

    @Override
    public void onRemove() throws Exception {
        this.ensureConfigured();
        this.logLifecycle("Removing", this.config);
        this.onRemove(this.config);
    }

    protected void onRemove(ConfigT config) throws Exception {
    }

    @Override
    public void onActivate() throws Exception {
        this.ensureConfigured();
        this.logLifecycle("Activating", this.config);
        this.onActivate(this.config);
    }

    protected void onActivate(ConfigT config) throws Exception {
    }

    @Override
    public void onPassivate() throws Exception {
        this.ensureConfigured();
        this.logLifecycle("Passivating", this.config);
        this.onPassivate(this.config);
    }

    protected void onPassivate(ConfigT config) throws Exception {
    }

    @Override
    public Condition activationCondition() {
        return null;
    }

    @Override
    public Condition validityCondition() {
        return null;
    }

    public String toString() {
        String id = null;
        if (this.context != null) {
            id = "'" + this.context.id().toString() + "'";
        }
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "id=" + id + ", config=" + this.config + '}';
    }

    @Inject
    public void installConditionComponents(Conditions conditions) {
        Preconditions.checkState((this.conditions == null ? 1 : 0) != 0);
        this.conditions = (Conditions)Preconditions.checkNotNull((Object)conditions);
    }

    protected Conditions conditions() {
        Preconditions.checkState((this.conditions != null ? 1 : 0) != 0);
        return this.conditions;
    }

    protected TemplateEngine getTemplateEngine() {
        Preconditions.checkState((this.templateEngine != null ? 1 : 0) != 0);
        return this.templateEngine;
    }

    @Inject
    public void installTemplateEngine(@Named(value="shared") TemplateEngine templateEngine) {
        Preconditions.checkState((this.templateEngine == null ? 1 : 0) != 0);
        this.templateEngine = (TemplateEngine)Preconditions.checkNotNull((Object)templateEngine);
    }

    protected String render(@NonNls String template, @Nullable Map<String, Object> params) {
        return this.getTemplateEngine().render((Object)this, template, params);
    }

    protected String render(@NonNls String template, TemplateParameters params) {
        return this.getTemplateEngine().render((Object)this, template, params);
    }

    protected String render(@NonNls String template) {
        return this.getTemplateEngine().render((Object)this, template, null);
    }

    protected String renderFailure(Throwable cause) {
        URL template = CapabilitySupport.class.getResource("failure.vm");
        return this.getTemplateEngine().render((Object)this, template, new TemplateParameters().set("cause", (Object)new TemplateThrowableAdapter(cause)));
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="FAILED: %s")
        public String failure(String var1);
    }
}

