/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.capability.support;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.sonatype.nexus.plugins.capabilities.CapabilityDescriptor;
import org.sonatype.nexus.plugins.capabilities.CapabilityIdentity;
import org.sonatype.nexus.plugins.capabilities.Validator;
import org.sonatype.nexus.plugins.capabilities.support.validator.Validators;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.goodies.template.TemplateEngine;
import org.sonatype.sisu.goodies.template.TemplateParameters;

public abstract class CapabilityDescriptorSupport
extends ComponentSupport
implements CapabilityDescriptor {
    private boolean exposed = true;
    private boolean hidden = false;
    private Validators validators;
    private TemplateEngine templateEngine;

    @Override
    public String about() {
        try {
            return this.renderAbout();
        }
        catch (Exception e) {
            this.log.warn("Failed to render about", (Throwable)e);
            return null;
        }
    }

    protected String renderAbout() throws Exception {
        return null;
    }

    @Override
    public boolean isExposed() {
        return this.exposed;
    }

    protected void setExposed(boolean exposed) {
        this.exposed = exposed;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    protected void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public int version() {
        return 1;
    }

    @Override
    public Map<String, String> convert(Map<String, String> properties, int fromVersion) {
        return properties;
    }

    @Inject
    public void installValidationComponents(Validators validators) {
        Preconditions.checkState((this.validators == null ? 1 : 0) != 0);
        this.validators = (Validators)Preconditions.checkNotNull((Object)validators);
    }

    protected Validators validators() {
        Preconditions.checkState((this.validators != null ? 1 : 0) != 0);
        return this.validators;
    }

    @Override
    public Validator validator() {
        return null;
    }

    @Override
    public Validator validator(CapabilityIdentity id) {
        return null;
    }

    protected TemplateEngine getTemplateEngine() {
        Preconditions.checkState((this.templateEngine != null ? 1 : 0) != 0);
        return this.templateEngine;
    }

    @Inject
    public void installTemplateEngine(@Named(value="shared") TemplateEngine templateEngine) {
        Preconditions.checkState((this.templateEngine == null ? 1 : 0) != 0);
        this.templateEngine = (TemplateEngine)Preconditions.checkNotNull((Object)templateEngine);
    }

    protected String render(@NonNls String template, @Nullable Map<String, Object> params) {
        return this.getTemplateEngine().render((Object)this, template, params);
    }

    protected String render(@NonNls String template, TemplateParameters params) {
        return this.getTemplateEngine().render((Object)this, template, params);
    }

    protected String render(@NonNls String template) {
        return this.getTemplateEngine().render((Object)this, template, null);
    }
}

