/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.plugin.console.api;

import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.codehaus.plexus.util.StringUtils;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.nexus.plugins.plugin.console.PluginConsoleManager;
import org.sonatype.nexus.plugins.plugin.console.api.dto.DocumentationLinkDTO;
import org.sonatype.nexus.plugins.plugin.console.api.dto.PluginInfoDTO;
import org.sonatype.nexus.plugins.plugin.console.api.dto.PluginInfoListResponseDTO;
import org.sonatype.nexus.plugins.plugin.console.model.DocumentationLink;
import org.sonatype.nexus.plugins.plugin.console.model.PluginInfo;
import org.sonatype.nexus.rest.AbstractNexusPlexusResource;
import org.sonatype.nexus.rest.model.AliasingListConverter;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;

@Path(value="/plugin_console/plugin_infos")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
@Named
@Singleton
public class PluginInfoListPlexusResource
extends AbstractNexusPlexusResource {
    private final PluginConsoleManager pluginConsoleManager;

    @Inject
    public PluginInfoListPlexusResource(PluginConsoleManager pluginConsoleManager) {
        this.pluginConsoleManager = (PluginConsoleManager)Preconditions.checkNotNull((Object)pluginConsoleManager);
        this.setReadable(true);
        this.setModifiable(false);
    }

    public void configureXStream(XStream xstream) {
        super.configureXStream(xstream);
        xstream.processAnnotations(PluginInfoDTO.class);
        xstream.processAnnotations(PluginInfoListResponseDTO.class);
        xstream.registerLocalConverter(PluginInfoListResponseDTO.class, "data", (Converter)new AliasingListConverter(PluginInfoDTO.class, "pluginInfo"));
    }

    public Object getPayloadInstance() {
        return null;
    }

    public String getResourceUri() {
        return "/plugin_console/plugin_infos";
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor(this.getResourceUri(), "authcBasic,perms[nexus:pluginconsoleplugininfos]");
    }

    @GET
    @ResourceMethodSignature(output=PluginInfoListResponseDTO.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        PluginInfoListResponseDTO result = new PluginInfoListResponseDTO();
        for (PluginInfo pluginInfo : this.pluginConsoleManager.listPluginInfo()) {
            result.addPluginInfo(this.nexusToRestModel(request, pluginInfo));
        }
        return result;
    }

    private PluginInfoDTO nexusToRestModel(Request request, PluginInfo pluginInfo) {
        PluginInfoDTO result = new PluginInfoDTO();
        result.setName(pluginInfo.getName());
        result.setStatus(pluginInfo.getStatus());
        result.setVersion(pluginInfo.getVersion());
        result.setDescription(pluginInfo.getDescription());
        result.setSite(pluginInfo.getSite());
        ArrayList<DocumentationLinkDTO> docUrls = new ArrayList<DocumentationLinkDTO>();
        for (DocumentationLink doc : pluginInfo.getDocumentation()) {
            DocumentationLinkDTO docLink = new DocumentationLinkDTO();
            docLink.setLabel(doc.getLabel());
            docLink.setUrl(this.createRootReference(request, doc.getUrl() + "/docs/index.html").getTargetRef().toString());
            docUrls.add(docLink);
        }
        result.setDocumentation(docUrls);
        result.setScmVersion(StringUtils.isEmpty((String)pluginInfo.getScmVersion()) ? "N/A" : pluginInfo.getScmVersion());
        result.setScmTimestamp(StringUtils.isEmpty((String)pluginInfo.getScmTimestamp()) ? "N/A" : pluginInfo.getScmTimestamp());
        result.setFailureReason(pluginInfo.getFailureReason());
        return result;
    }
}

