/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.plugin.console;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.plugin.support.DocumentationBundle;
import org.sonatype.nexus.plugins.NexusPluginManager;
import org.sonatype.nexus.plugins.PluginResponse;
import org.sonatype.nexus.plugins.plugin.console.PluginConsoleManager;
import org.sonatype.nexus.plugins.plugin.console.model.DocumentationLink;
import org.sonatype.nexus.plugins.plugin.console.model.PluginInfo;
import org.sonatype.nexus.web.WebResourceBundle;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class DefaultPluginConsoleManager
extends ComponentSupport
implements PluginConsoleManager {
    private final NexusPluginManager pluginManager;
    private final List<WebResourceBundle> resourceBundles;
    private final Multimap<String, DocumentationBundle> docBundles;

    @Inject
    public DefaultPluginConsoleManager(NexusPluginManager pluginManager, List<WebResourceBundle> resourceBundles) {
        this.pluginManager = (NexusPluginManager)Preconditions.checkNotNull((Object)pluginManager);
        this.resourceBundles = (List)Preconditions.checkNotNull(resourceBundles);
        this.docBundles = LinkedHashMultimap.create();
        for (WebResourceBundle rb : resourceBundles) {
            if (!(rb instanceof DocumentationBundle)) continue;
            DocumentationBundle doc = (DocumentationBundle)rb;
            this.docBundles.put((Object)doc.getPluginId(), (Object)doc);
        }
    }

    @Override
    public List<PluginInfo> listPluginInfo() {
        ArrayList<PluginInfo> result = new ArrayList<PluginInfo>();
        Map pluginResponses = this.pluginManager.getPluginResponses();
        for (PluginResponse pluginResponse : pluginResponses.values()) {
            result.add(this.buildPluginInfo(pluginResponse));
        }
        return result;
    }

    private PluginInfo buildPluginInfo(PluginResponse pluginResponse) {
        PluginInfo result = new PluginInfo();
        result.setStatus(pluginResponse.getAchievedGoal().name());
        result.setVersion(pluginResponse.getPluginCoordinates().getVersion());
        if (pluginResponse.getPluginDescriptor() != null) {
            result.setName(pluginResponse.getPluginDescriptor().getPluginMetadata().getName());
            result.setDescription(pluginResponse.getPluginDescriptor().getPluginMetadata().getDescription());
            result.setScmVersion(pluginResponse.getPluginDescriptor().getPluginMetadata().getScmVersion());
            result.setScmTimestamp(pluginResponse.getPluginDescriptor().getPluginMetadata().getScmTimestamp());
            result.setSite(pluginResponse.getPluginDescriptor().getPluginMetadata().getPluginSite());
        } else {
            result.setName(pluginResponse.getPluginCoordinates().getGroupId() + ":" + pluginResponse.getPluginCoordinates().getArtifactId());
        }
        Collection docs = this.docBundles.get((Object)pluginResponse.getPluginCoordinates().getArtifactId());
        if (docs != null && !docs.isEmpty()) {
            for (DocumentationBundle bundle : docs) {
                DocumentationLink link = new DocumentationLink();
                link.setLabel(bundle.getDescription());
                link.setUrl(bundle.getPluginId() + "/" + bundle.getPathPrefix());
                result.addDocumentation(link);
            }
        }
        if (!pluginResponse.isSuccessful()) {
            result.setFailureReason(pluginResponse.formatAsString(false));
        }
        return result;
    }
}

