/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.ehcache;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URL;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.management.MBeanServer;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.management.ManagementService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.sisu.ehcache.CacheManagerComponent;

@Named
@Singleton
public class CacheManagerComponentImpl
implements CacheManagerComponent {
    private static final Logger logger = LoggerFactory.getLogger(CacheManagerComponentImpl.class);
    private CacheManager cacheManager;

    @Inject
    public CacheManagerComponentImpl() throws IOException {
        this(null);
    }

    @VisibleForTesting
    public CacheManagerComponentImpl(@Nullable File file) throws IOException {
        this.cacheManager = this.createCacheManager(file);
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ManagementService.registerMBeans((CacheManager)this.cacheManager, (MBeanServer)mBeanServer, (boolean)false, (boolean)false, (boolean)true, (boolean)true);
        }
        catch (Exception e) {
            logger.warn("Failed to register mbean: {}", (Object)e.toString());
        }
    }

    @Override
    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public synchronized void shutdown() {
        if (this.cacheManager != null) {
            logger.info("Shutting down");
            this.cacheManager.shutdown();
            this.cacheManager = null;
        }
    }

    public void finalize() throws Throwable {
        try {
            this.shutdown();
        }
        finally {
            super.finalize();
        }
    }

    private CacheManager createCacheManager(@Nullable File file) throws IOException {
        URL url;
        if (file != null) {
            url = file.toURI().toURL();
        } else {
            url = this.getClass().getResource("/ehcache.xml");
            if (url == null) {
                url = this.getClass().getResource("/ehcache-default.xml");
            }
        }
        if (url == null) {
            logger.warn("No configuration found; using defaults");
            return new CacheManager();
        }
        logger.info("Loading configuration from: {}", (Object)url);
        Configuration configuration = ConfigurationFactory.parseConfiguration((URL)url);
        configuration.setUpdateCheck(false);
        return new CacheManager(configuration);
    }
}

