/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.rest.users;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResource;
import org.sonatype.plexus.rest.resource.PlexusResourceException;
import org.sonatype.security.rest.model.UserToRoleResource;
import org.sonatype.security.rest.model.UserToRoleResourceRequest;
import org.sonatype.security.rest.users.AbstractUserPlexusResource;
import org.sonatype.security.usermanagement.NoSuchUserManagerException;
import org.sonatype.security.usermanagement.RoleIdentifier;
import org.sonatype.security.usermanagement.UserNotFoundException;

@Singleton
@Typed(value={PlexusResource.class})
@Named(value="UserToRolePlexusResource")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
@Path(value="/user_to_roles/{sourceId}/{userId}")
public class UserToRolePlexusResource
extends AbstractUserPlexusResource {
    public static final String SOURCE_ID_KEY = "sourceId";
    public static final String RESOURCE_URI = "/user_to_roles/{sourceId}/{userId}";

    public UserToRolePlexusResource() {
        this.setModifiable(true);
        this.setReadable(true);
    }

    public Object getPayloadInstance() {
        return new UserToRoleResourceRequest();
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/user_to_roles/*/*", "authcBasic,perms[security:users]");
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    protected String getUserId(Request request) {
        return this.getRequestAttribute(request, "userId");
    }

    protected String getSourceId(Request request) {
        return this.getRequestAttribute(request, SOURCE_ID_KEY);
    }

    @PUT
    @ResourceMethodSignature(input=UserToRoleResourceRequest.class, pathParams={@PathParam(value="sourceId"), @PathParam(value="userId")})
    public Object put(Context context, Request request, Response response, Object payload) throws ResourceException {
        UserToRoleResourceRequest mappingRequest = (UserToRoleResourceRequest)payload;
        if (mappingRequest.getData() == null) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "User Role Mapping was not found in the Request.");
        }
        String userId = this.getUserId(request);
        String sourceId = this.getSourceId(request);
        try {
            if (this.getSecuritySystem().getUser(userId, sourceId) == null) {
                throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "User with id '" + userId + "' not found.");
            }
        }
        catch (UserNotFoundException e) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "User with id '" + userId + "' not found.");
        }
        catch (NoSuchUserManagerException e) {
            this.getLogger().warn(e.getMessage(), (Throwable)e);
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "User with id '" + userId + "' not found.");
        }
        UserToRoleResource userToRole = mappingRequest.getData();
        Set<RoleIdentifier> roleIdentifiers = this.restToSecurityModel(userToRole);
        if (roleIdentifiers.size() == 0) {
            throw new PlexusResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Configuration error.", (Object)this.getErrorResponse("roles", "User requires one or more roles."));
        }
        try {
            this.getSecuritySystem().setUsersRoles(userToRole.getUserId(), userToRole.getSource(), roleIdentifiers);
        }
        catch (InvalidConfigurationException e) {
            this.handleInvalidConfigurationException(e);
        }
        catch (UserNotFoundException e) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "User with id '" + userId + "' not found.");
        }
        response.setStatus(Status.SUCCESS_NO_CONTENT);
        return null;
    }

    @GET
    @ResourceMethodSignature(output=UserToRoleResourceRequest.class, pathParams={@PathParam(value="sourceId"), @PathParam(value="userId")})
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        String userId = this.getUserId(request);
        String sourceId = this.getSourceId(request);
        try {
            Set roleIds = this.getSecuritySystem().getUsersRoles(userId, sourceId);
            UserToRoleResourceRequest resp = new UserToRoleResourceRequest();
            resp.setData(this.securityToRestModel(userId, sourceId, roleIds));
            return resp;
        }
        catch (UserNotFoundException e) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "Could not find user '" + userId + "'.");
        }
        catch (NoSuchUserManagerException e) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "Could not find user manager for source '" + sourceId + "'.");
        }
    }

    @DELETE
    @ResourceMethodSignature(pathParams={@PathParam(value="sourceId"), @PathParam(value="userId")})
    public void delete(Context context, Request request, Response response) throws ResourceException {
        String userId = this.getUserId(request);
        String source = this.getSourceId(request);
        try {
            this.getSecuritySystem().setUsersRoles(userId, source, null);
        }
        catch (InvalidConfigurationException e) {
            this.handleInvalidConfigurationException(e);
        }
        catch (UserNotFoundException e) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "User with id '" + userId + "' not found.");
        }
    }

    private Set<RoleIdentifier> restToSecurityModel(UserToRoleResource restRoleMapping) {
        HashSet<RoleIdentifier> roleIdentifiers = new HashSet<RoleIdentifier>();
        for (String roleId : restRoleMapping.getRoles()) {
            roleIdentifiers.add(new RoleIdentifier("default", roleId));
        }
        return roleIdentifiers;
    }

    private UserToRoleResource securityToRestModel(String userId, String source, Set<RoleIdentifier> roleIds) {
        UserToRoleResource resource = new UserToRoleResource();
        resource.setUserId(userId);
        resource.setSource(source);
        ArrayList<String> roles = new ArrayList<String>();
        for (RoleIdentifier roleId : roleIds) {
            roles.add(roleId.getRoleId());
        }
        resource.setRoles(roles);
        return resource;
    }
}

