/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.rest.users;

import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResource;
import org.sonatype.security.authorization.NoSuchAuthorizationManagerException;
import org.sonatype.security.authorization.Role;
import org.sonatype.security.rest.model.PlexusUserListResourceResponse;
import org.sonatype.security.rest.model.PlexusUserSearchCriteriaResource;
import org.sonatype.security.rest.model.PlexusUserSearchCriteriaResourceRequest;
import org.sonatype.security.rest.users.AbstractUserSearchPlexusResource;
import org.sonatype.security.usermanagement.UserSearchCriteria;

@Singleton
@Typed(value={PlexusResource.class})
@Named(value="UserSearchPlexusResource")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
@Path(value="/user_search/{userSource}")
public class UserSearchPlexusResource
extends AbstractUserSearchPlexusResource {
    public static final String USER_ID_KEY = "userId";
    public static final String USER_SOURCE_KEY = "userSource";
    public static final String RESOURCE_URI = "/user_search/{userSource}";

    public UserSearchPlexusResource() {
        this.setModifiable(true);
        this.setRequireStrictChecking(false);
    }

    public Object getPayloadInstance() {
        return new PlexusUserSearchCriteriaResourceRequest();
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/user_search/**", "authcBasic,perms[security:users]");
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    @PUT
    @ResourceMethodSignature(input=PlexusUserSearchCriteriaResourceRequest.class, output=PlexusUserListResourceResponse.class, pathParams={@PathParam(value="sourceId")})
    public Object put(Context context, Request request, Response response, Object payload) throws ResourceException {
        PlexusUserSearchCriteriaResource criteriaResource = ((PlexusUserSearchCriteriaResourceRequest)payload).getData();
        UserSearchCriteria criteria = this.toPlexusSearchCriteria(criteriaResource);
        criteria.setSource(this.getUserSource(request));
        return this.search(criteria);
    }

    private UserSearchCriteria toPlexusSearchCriteria(PlexusUserSearchCriteriaResource criteriaResource) {
        UserSearchCriteria criteria = new UserSearchCriteria();
        criteria.setUserId(criteriaResource.getUserId());
        if (criteriaResource.isEffectiveUsers()) {
            HashSet<String> roleIds = new HashSet<String>();
            Set roles = null;
            try {
                roles = this.getSecuritySystem().listRoles("default");
            }
            catch (NoSuchAuthorizationManagerException e) {
                this.getLogger().error("Cannot find default UserManager,  effective user search may not work properly.", (Throwable)e);
                roles = this.getSecuritySystem().listRoles();
            }
            for (Role role : roles) {
                roleIds.add(role.getRoleId());
            }
            criteria.setOneOfRoleIds(roleIds);
        }
        return criteria;
    }

    @GET
    @ResourceMethodSignature(output=PlexusUserListResourceResponse.class, pathParams={@PathParam(value="sourceId")})
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        UserSearchCriteria criteria = new UserSearchCriteria();
        criteria.setUserId("");
        criteria.setSource(this.getUserSource(request));
        return this.search(criteria);
    }
}

