/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.rest.users;

import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResource;
import org.sonatype.security.rest.model.PlexusUserListResourceResponse;
import org.sonatype.security.rest.users.AbstractUserSearchPlexusResource;
import org.sonatype.security.usermanagement.UserSearchCriteria;

@Singleton
@Typed(value={PlexusResource.class})
@Named(value="UserSearchByIdPlexusResource")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
@Path(value="/user_search/{userSource}/{userId}")
public class UserSearchByIdPlexusResource
extends AbstractUserSearchPlexusResource {
    public static final String USER_ID_KEY = "userId";
    public static final String RESOURCE_URI = "/user_search/{userSource}/{userId}";

    public UserSearchByIdPlexusResource() {
        this.setModifiable(false);
    }

    public Object getPayloadInstance() {
        return null;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/user_search/*/*", "authcBasic,perms[security:users]");
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    @GET
    @ResourceMethodSignature(output=PlexusUserListResourceResponse.class, pathParams={@PathParam(value="userId"), @PathParam(value="sourceId")})
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        UserSearchCriteria criteria = new UserSearchCriteria();
        criteria.setUserId(this.getSearchArg(request));
        criteria.setSource(this.getUserSource(request));
        return this.search(criteria);
    }

    protected String getSearchArg(Request request) {
        return this.getRequestAttribute(request, USER_ID_KEY);
    }
}

