/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.rest.users;

import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResource;
import org.sonatype.security.rest.users.AbstractUserPlexusResource;
import org.sonatype.security.usermanagement.UserNotFoundException;

@Singleton
@Typed(value={PlexusResource.class})
@Named(value="UserResetPlexusResource")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
@Path(value="/users_reset/{userId}")
public class UserResetPlexusResource
extends AbstractUserPlexusResource {
    public static final String RESOURCE_URI = "/users_reset/{userId}";

    public UserResetPlexusResource() {
        this.setModifiable(true);
    }

    public Object getPayloadInstance() {
        return null;
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/users_reset/*", "authcBasic,perms[security:usersreset]");
    }

    @DELETE
    @ResourceMethodSignature(pathParams={@PathParam(value="userId")})
    public void delete(Context context, Request request, Response response) throws ResourceException {
        String userId = this.getRequestAttribute(request, "userId");
        try {
            if (this.isAnonymousUser(userId, request)) {
                this.getLogger().debug("Anonymous user password reset is blocked!");
                throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Anonymous user cannot reset password!");
            }
            this.getSecuritySystem().resetPassword(userId);
            response.setStatus(Status.SUCCESS_NO_CONTENT);
        }
        catch (UserNotFoundException e) {
            this.getLogger().debug("Invalid userid: " + userId, (Throwable)e);
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "User ID not found!", (Throwable)e);
        }
        catch (InvalidConfigurationException e) {
            this.getLogger().warn("Failed to set password!", (Throwable)e);
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Failed to set password!.", (Throwable)e);
        }
    }
}

