/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.rest.users;

import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResource;
import org.sonatype.plexus.rest.resource.PlexusResourceException;
import org.sonatype.plexus.rest.resource.error.ErrorResponse;
import org.sonatype.security.rest.model.UserResource;
import org.sonatype.security.rest.model.UserResourceRequest;
import org.sonatype.security.rest.model.UserResourceResponse;
import org.sonatype.security.rest.users.AbstractUserPlexusResource;
import org.sonatype.security.usermanagement.NoSuchUserManagerException;
import org.sonatype.security.usermanagement.User;
import org.sonatype.security.usermanagement.UserNotFoundException;

@Singleton
@Typed(value={PlexusResource.class})
@Named(value="UserPlexusResource")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
@Path(value="/users/{userId}")
public class UserPlexusResource
extends AbstractUserPlexusResource {
    public static final String RESOURCE_URI = "/users/{userId}";

    public UserPlexusResource() {
        this.setModifiable(true);
    }

    public Object getPayloadInstance() {
        return new UserResourceRequest();
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/users/*", "authcBasic,perms[security:users]");
    }

    protected String getUserId(Request request) {
        return this.getRequestAttribute(request, "userId");
    }

    @GET
    @ResourceMethodSignature(output=UserResourceResponse.class, pathParams={@PathParam(value="userId")})
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        UserResourceResponse result = new UserResourceResponse();
        try {
            result.setData(this.securityToRestModel(this.getSecuritySystem().getUser(this.getUserId(request)), request, false));
        }
        catch (UserNotFoundException e) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, e.getMessage());
        }
        return result;
    }

    @POST
    @ResourceMethodSignature(output=UserResourceResponse.class, pathParams={@PathParam(value="userId")})
    public Object put(Context context, Request request, Response response, Object payload) throws ResourceException {
        UserResourceRequest resourceRequest = (UserResourceRequest)payload;
        UserResourceResponse result = null;
        if (resourceRequest != null) {
            UserResource resource = resourceRequest.getData();
            if (StringUtils.isNotEmpty((String)resource.getPassword())) {
                throw new PlexusResourceException(Status.CLIENT_ERROR_BAD_REQUEST, (Object)this.getErrorResponse("*", "Updating a users password using this URI is not allowed."));
            }
            try {
                User user = this.restToSecurityModel(this.getSecuritySystem().getUser(resource.getUserId()), resource);
                this.validateUserContainment(user);
                this.getSecuritySystem().updateUser(user);
                result = new UserResourceResponse();
                result.setData(resourceRequest.getData());
                result.getData().setResourceURI(this.createChildReference(request, resource.getUserId()).toString());
            }
            catch (InvalidConfigurationException e) {
                this.handleInvalidConfigurationException(e);
            }
            catch (UserNotFoundException e) {
                throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, e.getMessage());
            }
            catch (NoSuchUserManagerException e) {
                ErrorResponse errorResponse = this.getErrorResponse("*", e.getMessage());
                throw new PlexusResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Unable to create user.", (Object)errorResponse);
            }
        }
        return result;
    }

    @DELETE
    @ResourceMethodSignature(pathParams={@PathParam(value="userId")})
    public void delete(Context context, Request request, Response response) throws ResourceException {
        try {
            if (this.isAnonymousUser(this.getUserId(request), request)) {
                String error = "The user with user ID [" + this.getUserId(request) + "] cannot be deleted, since it is marked user used for Anonymous access in Server Administration. To delete this user, disable anonymous access or, change the anonymous username and password to another valid values!";
                this.getLogger().info("Anonymous user cannot be deleted! Unset the Allow Anonymous access first in Server Administration!");
                throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, error);
            }
            if (this.isCurrentUser(request)) {
                String error = "The user with user ID [" + this.getUserId(request) + "] cannot be deleted, as that is the user currently logged into the application.";
                this.getLogger().info("The user with user ID [" + this.getUserId(request) + "] cannot be deleted, as that is the user currently logged into the application.");
                throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, error);
            }
            this.getSecuritySystem().deleteUser(this.getUserId(request));
            response.setStatus(Status.SUCCESS_NO_CONTENT);
        }
        catch (UserNotFoundException e) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, e.getMessage());
        }
    }

    protected boolean isCurrentUser(Request request) {
        Subject subject = SecurityUtils.getSubject();
        if (subject == null || subject.getPrincipal() == null) {
            return false;
        }
        return subject.getPrincipal().equals(this.getUserId(request));
    }
}

