/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.rest.users;

import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.commons.lang.StringUtils;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.eclipse.sisu.BeanEntry;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.plexus.rest.resource.AbstractPlexusResource;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResource;
import org.sonatype.security.rest.model.PlexusComponentListResource;
import org.sonatype.security.rest.model.PlexusComponentListResourceResponse;
import org.sonatype.security.usermanagement.UserManager;

@Singleton
@Typed(value={PlexusResource.class})
@Named(value="UserLocatorComponentListPlexusResource")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
@Path(value="/components/userLocators")
public class UserLocatorComponentListPlexusResource
extends AbstractPlexusResource {
    public static final String RESOURCE_URI = "/components/userLocators";
    @Inject
    private Iterable<BeanEntry<Named, UserManager>> userManagers;

    public Object getPayloadInstance() {
        return null;
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor(this.getResourceUri(), "authcBasic,perms[security:componentsuserlocatortypes]");
    }

    @GET
    @ResourceMethodSignature(output=PlexusComponentListResourceResponse.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        PlexusComponentListResourceResponse result = new PlexusComponentListResourceResponse();
        if (this.userManagers != null) {
            for (BeanEntry<Named, UserManager> entry : this.userManagers) {
                String hint = ((Named)entry.getKey()).value();
                String description = entry.getDescription();
                PlexusComponentListResource resource = new PlexusComponentListResource();
                resource.setRoleHint(hint);
                resource.setDescription(StringUtils.isNotEmpty((String)description) ? description : hint);
                result.addData(resource);
            }
        }
        if (result.getData().isEmpty()) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND);
        }
        return result;
    }
}

