/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.rest.users;

import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResource;
import org.sonatype.plexus.rest.resource.PlexusResourceException;
import org.sonatype.plexus.rest.resource.error.ErrorResponse;
import org.sonatype.security.rest.model.UserListResourceResponse;
import org.sonatype.security.rest.model.UserResource;
import org.sonatype.security.rest.model.UserResourceRequest;
import org.sonatype.security.rest.model.UserResourceResponse;
import org.sonatype.security.rest.users.AbstractUserPlexusResource;
import org.sonatype.security.usermanagement.NoSuchUserManagerException;
import org.sonatype.security.usermanagement.User;
import org.sonatype.security.usermanagement.UserSearchCriteria;

@Singleton
@Typed(value={PlexusResource.class})
@Named(value="UserListPlexusResource")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
@Path(value="/users")
public class UserListPlexusResource
extends AbstractUserPlexusResource {
    public static final String RESOURCE_URI = "/users";

    public UserListPlexusResource() {
        this.setModifiable(true);
    }

    public Object getPayloadInstance() {
        return new UserResourceRequest();
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor(this.getResourceUri(), "authcBasic,perms[security:users]");
    }

    @GET
    @ResourceMethodSignature(output=UserListResourceResponse.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        UserListResourceResponse result = new UserListResourceResponse();
        for (User user : this.getSecuritySystem().searchUsers(new UserSearchCriteria(null, null, "default"))) {
            UserResource res = this.securityToRestModel(user, request, true);
            if (res == null) continue;
            result.addData(res);
        }
        return result;
    }

    @POST
    @ResourceMethodSignature(input=UserResourceRequest.class, output=UserResourceResponse.class)
    public Object post(Context context, Request request, Response response, Object payload) throws ResourceException {
        UserResourceRequest requestResource = (UserResourceRequest)payload;
        UserResourceResponse result = null;
        if (requestResource != null) {
            UserResource resource = requestResource.getData();
            try {
                User user = this.restToSecurityModel(null, resource);
                this.validateUserContainment(user);
                String password = resource.getPassword();
                this.getSecuritySystem().addUser(user, password);
                result = new UserResourceResponse();
                resource.setStatus(user.getStatus().name());
                resource.setResourceURI(this.createChildReference(request, resource.getUserId()).toString());
                result.setData(resource);
            }
            catch (InvalidConfigurationException e) {
                this.handleInvalidConfigurationException(e);
            }
            catch (NoSuchUserManagerException e) {
                ErrorResponse errorResponse = this.getErrorResponse("*", e.getMessage());
                throw new PlexusResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Unable to create user.", (Object)errorResponse);
            }
        }
        return result;
    }
}

