/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.rest.users;

import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResource;
import org.sonatype.security.rest.model.UserForgotPasswordRequest;
import org.sonatype.security.rest.model.UserForgotPasswordResource;
import org.sonatype.security.rest.users.AbstractUserPlexusResource;
import org.sonatype.security.usermanagement.UserNotFoundException;

@Singleton
@Typed(value={PlexusResource.class})
@Named(value="UserForgotPasswordPlexusResource")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
@Path(value="/users_forgotpw")
public class UserForgotPasswordPlexusResource
extends AbstractUserPlexusResource {
    public static final String RESOURCE_URI = "/users_forgotpw";

    public UserForgotPasswordPlexusResource() {
        this.setModifiable(true);
    }

    public Object getPayloadInstance() {
        return new UserForgotPasswordRequest();
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor(this.getResourceUri(), "authcBasic,perms[security:usersforgotpw]");
    }

    @POST
    @ResourceMethodSignature(input=UserForgotPasswordRequest.class)
    public Object post(Context context, Request request, Response response, Object payload) throws ResourceException {
        UserForgotPasswordRequest forgotPasswordRequest = (UserForgotPasswordRequest)payload;
        if (forgotPasswordRequest != null) {
            UserForgotPasswordResource resource = forgotPasswordRequest.getData();
            try {
                if (!this.isAnonymousUser(resource.getUserId(), request)) {
                    this.getSecuritySystem().forgotPassword(resource.getUserId(), resource.getEmail());
                    response.setStatus(Status.SUCCESS_ACCEPTED);
                } else {
                    response.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, "Anonymous user cannot forget password");
                    this.getLogger().debug("Anonymous user forgot password is blocked");
                }
            }
            catch (UserNotFoundException e) {
                this.getLogger().debug("Invalid Username", (Throwable)e);
                throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Invalid Username");
            }
            catch (InvalidConfigurationException e) {
                this.getLogger().warn("Failed to set password!", (Throwable)e);
                throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Failed to set password!.");
            }
        }
        return null;
    }
}

