/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.rest.users;

import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResource;
import org.sonatype.security.rest.users.AbstractUserPlexusResource;
import org.sonatype.security.usermanagement.UserNotFoundException;

@Singleton
@Typed(value={PlexusResource.class})
@Named(value="UserForgotIdPlexusResource")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
@Path(value="/users_forgotid/{email}")
public class UserForgotIdPlexusResource
extends AbstractUserPlexusResource {
    public static final String RESOURCE_URI = "/users_forgotid/{email}";

    public UserForgotIdPlexusResource() {
        this.setModifiable(true);
    }

    public Object getPayloadInstance() {
        return null;
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/users_forgotid/*", "authcBasic,perms[security:usersforgotid]");
    }

    @POST
    @ResourceMethodSignature(pathParams={@PathParam(value="email")})
    public Object post(Context context, Request request, Response response, Object payload) throws ResourceException {
        String email = this.getRequestAttribute(request, "email");
        try {
            this.getSecuritySystem().forgotUsername(email);
            response.setStatus(Status.SUCCESS_ACCEPTED);
        }
        catch (UserNotFoundException e) {
            this.getLogger().debug("Invalid email received: " + email, (Throwable)e);
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Email address not found!");
        }
        return null;
    }
}

