/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.rest.users;

import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResource;
import org.sonatype.security.rest.model.UserChangePasswordRequest;
import org.sonatype.security.rest.model.UserChangePasswordResource;
import org.sonatype.security.rest.users.AbstractUserPlexusResource;
import org.sonatype.security.usermanagement.InvalidCredentialsException;
import org.sonatype.security.usermanagement.UserNotFoundException;

@Singleton
@Typed(value={PlexusResource.class})
@Named(value="UserChangePasswordPlexusResource")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
@Path(value="/users_changepw")
public class UserChangePasswordPlexusResource
extends AbstractUserPlexusResource {
    public static final String RESOURCE_URI = "/users_changepw";

    public UserChangePasswordPlexusResource() {
        this.setModifiable(true);
    }

    public Object getPayloadInstance() {
        return new UserChangePasswordRequest();
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor(this.getResourceUri(), "authcBasic,perms[security:userschangepw]");
    }

    @POST
    @ResourceMethodSignature(input=UserChangePasswordRequest.class)
    public Object post(Context context, Request request, Response response, Object payload) throws ResourceException {
        UserChangePasswordRequest changePasswordRequest = (UserChangePasswordRequest)payload;
        if (changePasswordRequest != null) {
            UserChangePasswordResource resource = changePasswordRequest.getData();
            try {
                if (!this.isAnonymousUser(resource.getUserId(), request)) {
                    this.getSecuritySystem().changePassword(resource.getUserId(), resource.getOldPassword(), resource.getNewPassword());
                    response.setStatus(Status.SUCCESS_ACCEPTED);
                } else {
                    response.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, "Anonymous user cannot change password!");
                    this.getLogger().debug("Anonymous user password change is blocked!");
                }
            }
            catch (UserNotFoundException e) {
                this.getLogger().debug("Invalid user ID!", (Throwable)e);
                throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Invalid credentials supplied.");
            }
            catch (InvalidCredentialsException e) {
                this.getLogger().debug("Invalid credentials!", (Throwable)e);
                throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Invalid credentials supplied.");
            }
            catch (InvalidConfigurationException e) {
                this.getLogger().warn("Failed to set password!", (Throwable)e);
                throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Failed to set password!.");
            }
        }
        return null;
    }
}

