/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.rest.users;

import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResource;
import org.sonatype.security.rest.AbstractSecurityPlexusResource;
import org.sonatype.security.rest.model.PlexusUserResource;
import org.sonatype.security.rest.model.PlexusUserResourceResponse;
import org.sonatype.security.usermanagement.NoSuchUserManagerException;
import org.sonatype.security.usermanagement.User;
import org.sonatype.security.usermanagement.UserNotFoundException;

@Singleton
@Typed(value={PlexusResource.class})
@Named(value="UserBySourcePlexusResource")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
@Path(value="/plexus_user/{userSource}/{userId}")
public class UserBySourcePlexusResource
extends AbstractSecurityPlexusResource {
    public static final String USER_ID_KEY = "userId";
    public static final String USER_SOURCE_KEY = "userSource";
    public static final String RESOURCE_URI = "/plexus_user/{userSource}/{userId}";

    public UserBySourcePlexusResource() {
        this.setModifiable(false);
    }

    public Object getPayloadInstance() {
        return null;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/plexus_user/*/*", "authcBasic,perms[security:users]");
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    @GET
    @ResourceMethodSignature(output=PlexusUserResourceResponse.class, pathParams={@PathParam(value="sourceId"), @PathParam(value="sourceId")})
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        User user;
        PlexusUserResourceResponse result = new PlexusUserResourceResponse();
        try {
            String source = this.getUserSource(request);
            user = "all".equalsIgnoreCase(source) ? this.getSecuritySystem().getUser(this.getUserId(request)) : this.getSecuritySystem().getUser(this.getUserId(request), source);
        }
        catch (UserNotFoundException e) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND);
        }
        catch (NoSuchUserManagerException e) {
            this.getLogger().warn(e.getMessage(), (Throwable)e);
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND);
        }
        if (user == null) {
            // empty if block
        }
        PlexusUserResource resource = this.securityToRestModel(user);
        result.setData(resource);
        return result;
    }

    protected String getUserId(Request request) {
        return this.getRequestAttribute(request, USER_ID_KEY);
    }

    protected String getUserSource(Request request) {
        return this.getRequestAttribute(request, USER_SOURCE_KEY);
    }
}

