/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.rest.users;

import org.restlet.data.Request;
import org.restlet.data.Status;
import org.restlet.resource.Representation;
import org.restlet.resource.ResourceException;
import org.sonatype.plexus.rest.resource.PlexusResourceException;
import org.sonatype.security.rest.AbstractSecurityPlexusResource;
import org.sonatype.security.rest.model.UserResource;
import org.sonatype.security.usermanagement.User;

public abstract class AbstractUserPlexusResource
extends AbstractSecurityPlexusResource {
    public static final String USER_ID_KEY = "userId";
    public static final String USER_EMAIL_KEY = "email";
    private static final String ROLE_VALIDATION_ERROR = "The user cannot have zero roles!";

    protected boolean validateFields(UserResource resource, Representation representation) throws PlexusResourceException {
        if (resource.getRoles() == null || resource.getRoles().size() == 0) {
            this.getLogger().info("The userId (" + resource.getUserId() + ") cannot have 0 roles!");
            throw new PlexusResourceException(Status.CLIENT_ERROR_BAD_REQUEST, ROLE_VALIDATION_ERROR, (Object)this.getErrorResponse("users", ROLE_VALIDATION_ERROR));
        }
        return true;
    }

    protected boolean isAnonymousUser(String username, Request request) throws ResourceException {
        return this.getSecuritySystem().isAnonymousAccessEnabled() && this.getSecuritySystem().getAnonymousUsername().equals(username);
    }

    protected void validateUserContainment(User user) throws ResourceException {
        if (user.getRoles().size() == 0) {
            throw new PlexusResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Configuration error.", (Object)this.getErrorResponse("roles", "User requires one or more roles."));
        }
    }
}

