/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.rest.roles;

import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResource;
import org.sonatype.security.authorization.AuthorizationManager;
import org.sonatype.security.authorization.NoSuchAuthorizationManagerException;
import org.sonatype.security.authorization.NoSuchRoleException;
import org.sonatype.security.authorization.Role;
import org.sonatype.security.rest.model.RoleListResourceResponse;
import org.sonatype.security.rest.model.RoleResource;
import org.sonatype.security.rest.model.RoleResourceRequest;
import org.sonatype.security.rest.model.RoleResourceResponse;
import org.sonatype.security.rest.roles.AbstractRolePlexusResource;

@Singleton
@Typed(value={PlexusResource.class})
@Named(value="RolePlexusResource")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
@Path(value="/roles/{roleId}")
public class RolePlexusResource
extends AbstractRolePlexusResource {
    public static final String ROLE_ID_KEY = "roleId";
    public static final String RESOURCE_URI = "/roles/{roleId}";

    public RolePlexusResource() {
        this.setModifiable(true);
    }

    public Object getPayloadInstance() {
        return new RoleResourceRequest();
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/roles/*", "authcBasic,perms[security:roles]");
    }

    protected String getRoleId(Request request) {
        return this.getRequestAttribute(request, ROLE_ID_KEY);
    }

    @GET
    @ResourceMethodSignature(output=RoleResourceResponse.class, pathParams={@PathParam(value="roleId")})
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        RoleResourceResponse result = new RoleResourceResponse();
        try {
            AuthorizationManager authzManager = this.getSecuritySystem().getAuthorizationManager("default");
            result.setData(this.securityToRestModel(authzManager.getRole(this.getRoleId(request)), request, false));
        }
        catch (NoSuchRoleException e) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, e.getMessage());
        }
        catch (NoSuchAuthorizationManagerException e) {
            this.getLogger().warn("Could not found AuthorizationManager: default", (Throwable)e);
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Authorization Manager for: default could not be found.");
        }
        return result;
    }

    @PUT
    @ResourceMethodSignature(input=RoleResourceRequest.class, output=RoleListResourceResponse.class, pathParams={@PathParam(value="roleId")})
    public Object put(Context context, Request request, Response response, Object payload) throws ResourceException {
        RoleResourceRequest resourceRequest = (RoleResourceRequest)payload;
        RoleResourceResponse resourceResponse = new RoleResourceResponse();
        if (resourceRequest != null) {
            RoleResource resource = resourceRequest.getData();
            try {
                AuthorizationManager authzManager = this.getSecuritySystem().getAuthorizationManager("default");
                Role role = this.restToSecurityModel(authzManager.getRole(resource.getId()), resource);
                this.validateRoleContainment(role);
                authzManager.updateRole(role);
                resourceResponse = new RoleResourceResponse();
                resourceResponse.setData(resourceRequest.getData());
                resourceResponse.getData().setUserManaged(!role.isReadOnly());
                resourceResponse.getData().setResourceURI(this.createChildReference(request, resource.getId()).toString());
            }
            catch (NoSuchRoleException e) {
                throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, e.getMessage());
            }
            catch (InvalidConfigurationException e) {
                this.handleInvalidConfigurationException(e);
            }
            catch (NoSuchAuthorizationManagerException e) {
                this.getLogger().warn("Could not found AuthorizationManager: default", (Throwable)e);
                throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Authorization Manager for: default could not be found.");
            }
        }
        return resourceResponse;
    }

    @DELETE
    @ResourceMethodSignature(pathParams={@PathParam(value="roleId")})
    public void delete(Context context, Request request, Response response) throws ResourceException {
        try {
            AuthorizationManager authzManager = this.getSecuritySystem().getAuthorizationManager("default");
            authzManager.deleteRole(this.getRoleId(request));
        }
        catch (NoSuchRoleException e) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, e.getMessage());
        }
        catch (NoSuchAuthorizationManagerException e) {
            this.getLogger().warn("Could not found AuthorizationManager: default", (Throwable)e);
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Authorization Manager for: default could not be found.");
        }
    }
}

