/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.rest.roles;

import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResource;
import org.sonatype.security.authorization.AuthorizationManager;
import org.sonatype.security.authorization.NoSuchAuthorizationManagerException;
import org.sonatype.security.authorization.Role;
import org.sonatype.security.rest.model.RoleListResourceResponse;
import org.sonatype.security.rest.model.RoleResource;
import org.sonatype.security.rest.model.RoleResourceRequest;
import org.sonatype.security.rest.model.RoleResourceResponse;
import org.sonatype.security.rest.roles.AbstractRolePlexusResource;

@Singleton
@Typed(value={PlexusResource.class})
@Named(value="RoleListPlexusResource")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
@Path(value="/roles")
public class RoleListPlexusResource
extends AbstractRolePlexusResource {
    public static final String RESOURCE_URI = "/roles";

    public RoleListPlexusResource() {
        this.setModifiable(true);
    }

    public Object getPayloadInstance() {
        return new RoleResourceRequest();
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor(this.getResourceUri(), "authcBasic,perms[security:roles]");
    }

    @GET
    @ResourceMethodSignature(output=RoleListResourceResponse.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        RoleListResourceResponse result = new RoleListResourceResponse();
        try {
            for (Role role : this.getSecuritySystem().getAuthorizationManager("default").listRoles()) {
                RoleResource res = this.securityToRestModel(role, request, true);
                if (res == null) continue;
                result.addData(res);
            }
        }
        catch (NoSuchAuthorizationManagerException e) {
            this.getLogger().error("Unable to find AuthorizationManager 'default'", (Throwable)e);
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, "Unable to find AuthorizationManager 'default'");
        }
        return result;
    }

    @POST
    @ResourceMethodSignature(input=RoleResourceRequest.class, output=RoleResourceResponse.class)
    public Object post(Context context, Request request, Response response, Object payload) throws ResourceException {
        RoleResourceRequest resourceRequest = (RoleResourceRequest)payload;
        RoleResourceResponse result = null;
        if (resourceRequest != null) {
            RoleResource resource = resourceRequest.getData();
            Role role = this.restToSecurityModel(null, resource);
            try {
                this.validateRoleContainment(role);
                AuthorizationManager authzManager = this.getSecuritySystem().getAuthorizationManager("default");
                role = authzManager.addRole(role);
                result = new RoleResourceResponse();
                resource.setId(role.getRoleId());
                resource.setUserManaged(true);
                resource.setResourceURI(this.createChildReference(request, resource.getId()).toString());
                result.setData(resource);
            }
            catch (InvalidConfigurationException e) {
                this.handleInvalidConfigurationException(e);
            }
            catch (NoSuchAuthorizationManagerException e) {
                this.getLogger().warn("Could not found AuthorizationManager: default", (Throwable)e);
                throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Authorization Manager for: default could not be found.");
            }
        }
        return result;
    }
}

