/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.rest.roles;

import java.util.Comparator;
import org.sonatype.security.rest.model.RoleAndPrivilegeListResource;

public final class RoleAndPrivilegeListResourceComparator
implements Comparator<RoleAndPrivilegeListResource> {
    private final String sort;
    private final String dir;
    public static final String SORT_NAME = "name";
    public static final String SORT_DESCRIPTION = "description";
    public static final String DIR_ASC = "ASC";
    public static final String DIR_DESC = "DESC";

    public RoleAndPrivilegeListResourceComparator(String sort, String dir) {
        this.sort = sort;
        this.dir = dir;
    }

    @Override
    public int compare(RoleAndPrivilegeListResource o1, RoleAndPrivilegeListResource o2) {
        if (o1.getType().equals("role") && o2.getType().equals("privilege")) {
            return -1;
        }
        if (o1.getType().equals("privilege") && o2.getType().equals("role")) {
            return 1;
        }
        if (SORT_NAME.equals(this.sort)) {
            return this.doCompare(o1.getName(), o2.getName(), this.dir);
        }
        if (SORT_DESCRIPTION.equals(this.sort)) {
            return this.doCompare(o1.getDescription(), o2.getDescription(), this.dir);
        }
        return 0;
    }

    private int doCompare(String value1, String value2, String dir) {
        if (DIR_DESC.equals(dir)) {
            return value2.compareToIgnoreCase(value1);
        }
        return value1.compareToIgnoreCase(value2);
    }
}

