/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.rest.roles;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.commons.lang.StringUtils;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Form;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResource;
import org.sonatype.security.authorization.NoSuchAuthorizationManagerException;
import org.sonatype.security.authorization.Privilege;
import org.sonatype.security.authorization.Role;
import org.sonatype.security.rest.AbstractSecurityPlexusResource;
import org.sonatype.security.rest.model.PlexusRoleResource;
import org.sonatype.security.rest.model.RoleAndPrivilegeListFilterResourceRequest;
import org.sonatype.security.rest.model.RoleAndPrivilegeListResource;
import org.sonatype.security.rest.model.RoleAndPrivilegeListResourceResponse;
import org.sonatype.security.rest.model.RoleListResourceResponse;
import org.sonatype.security.rest.roles.FilterRequest;
import org.sonatype.security.rest.roles.RoleAndPrivilegeListResourceComparator;
import org.sonatype.security.usermanagement.User;
import org.sonatype.security.usermanagement.UserNotFoundException;

@Singleton
@Typed(value={PlexusResource.class})
@Named(value="RoleAndPrivilegeListPlexusResource")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
@Path(value="/rolesAndPrivs")
public class RoleAndPrivilegeListPlexusResource
extends AbstractSecurityPlexusResource {
    public static final String RESOURCE_URI = "/rolesAndPrivs";
    public static final String REQUEST_SORT = "sort";
    public static final String REQUEST_DIR = "dir";
    public static final String REQUEST_START = "start";
    public static final String REQUEST_LIMIT = "limit";

    public RoleAndPrivilegeListPlexusResource() {
        this.setReadable(false);
        this.setModifiable(true);
    }

    public Object getPayloadInstance() {
        return new RoleAndPrivilegeListFilterResourceRequest();
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor(this.getResourceUri(), "authcBasic,perms[security:roles]");
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    @POST
    @ResourceMethodSignature(input=RoleAndPrivilegeListFilterResourceRequest.class, output=RoleListResourceResponse.class)
    public Object post(Context context, Request request, Response response, Object payload) throws ResourceException {
        RoleAndPrivilegeListResourceResponse result = new RoleAndPrivilegeListResourceResponse();
        ArrayList<RoleAndPrivilegeListResource> resources = new ArrayList<RoleAndPrivilegeListResource>();
        RoleAndPrivilegeListFilterResourceRequest filterRequest = (RoleAndPrivilegeListFilterResourceRequest)payload;
        try {
            RoleAndPrivilegeListResource res;
            Form form = request.getResourceRef().getQueryAsForm();
            FilterRequest filter = new FilterRequest(filterRequest);
            for (Role role : this.getSecuritySystem().getAuthorizationManager("default").listRoles()) {
                res = this.toDTO(role);
                if (!filter.applies(res)) continue;
                resources.add(res);
            }
            for (Privilege privilege : this.getSecuritySystem().getAuthorizationManager("default").listPrivileges()) {
                res = this.toDTO(privilege);
                if (!filter.applies(res)) continue;
                resources.add(res);
            }
            if (!StringUtils.isEmpty((String)filterRequest.getData().getUserId())) {
                try {
                    User user = this.getSecuritySystem().getUser(filterRequest.getData().getUserId());
                    List plexusRoles = this.securityToRestModel(user).getRoles();
                    for (PlexusRoleResource plexusRole : plexusRoles) {
                        RoleAndPrivilegeListResource res2;
                        if ("default".equals(plexusRole.getSource()) || !filter.applies(res2 = this.toDTO(plexusRole))) continue;
                        resources.add(res2);
                    }
                }
                catch (UserNotFoundException e) {
                    this.getLogger().warn("Unable to load user, and retrieve any external roles assigned", (Throwable)e);
                }
            }
            result.setTotalCount(resources.size());
            result.setData(this.generateResultSet(resources, form));
        }
        catch (NoSuchAuthorizationManagerException e) {
            this.getLogger().error("Unable to find AuthorizationManager 'default'", (Throwable)e);
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, "Unable to find AuthorizationManager 'default'");
        }
        return result;
    }

    protected RoleAndPrivilegeListResource toDTO(Role role) {
        RoleAndPrivilegeListResource resource = new RoleAndPrivilegeListResource();
        resource.setId(role.getRoleId());
        resource.setName(role.getName());
        resource.setDescription(role.getDescription());
        resource.setType("role");
        return resource;
    }

    protected RoleAndPrivilegeListResource toDTO(Privilege privilege) {
        RoleAndPrivilegeListResource resource = new RoleAndPrivilegeListResource();
        resource.setId(privilege.getId());
        resource.setName(privilege.getName());
        resource.setDescription(privilege.getDescription());
        resource.setType("privilege");
        return resource;
    }

    protected RoleAndPrivilegeListResource toDTO(PlexusRoleResource roleResource) {
        RoleAndPrivilegeListResource resource = new RoleAndPrivilegeListResource();
        resource.setId(roleResource.getRoleId());
        resource.setName(roleResource.getName());
        resource.setDescription("External role from the " + roleResource.getSource() + " realm, this role cannot be removed.");
        resource.setType("role");
        resource.setExternal(true);
        return resource;
    }

    protected List<RoleAndPrivilegeListResource> generateResultSet(List<RoleAndPrivilegeListResource> resources, Form form) {
        String sort = form.getFirstValue(REQUEST_SORT);
        String dir = form.getFirstValue(REQUEST_DIR);
        this.sortResultSet(resources, sort, dir);
        String start = form.getFirstValue(REQUEST_START);
        String limit = form.getFirstValue(REQUEST_LIMIT);
        resources = this.paginateResultSet(resources, start, limit);
        return resources;
    }

    protected void sortResultSet(List<RoleAndPrivilegeListResource> resources, String sort, String dir) {
        if (!StringUtils.isEmpty((String)sort)) {
            RoleAndPrivilegeListResourceComparator comparator = new RoleAndPrivilegeListResourceComparator(sort, dir);
            Collections.sort(resources, comparator);
        }
    }

    protected List<RoleAndPrivilegeListResource> paginateResultSet(List<RoleAndPrivilegeListResource> resources, String startStr, String limitStr) {
        int limit;
        int start;
        try {
            start = Integer.parseInt(startStr);
        }
        catch (Throwable t) {
            start = 0;
        }
        try {
            limit = Integer.parseInt(limitStr);
        }
        catch (Throwable t) {
            limit = Integer.MAX_VALUE;
        }
        ArrayList<RoleAndPrivilegeListResource> result = new ArrayList<RoleAndPrivilegeListResource>();
        for (int i = start; i < start + limit && i < resources.size(); ++i) {
            result.add(resources.get(i));
        }
        return result;
    }
}

