/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.rest.roles;

import java.util.Set;
import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResource;
import org.sonatype.security.authorization.NoSuchAuthorizationManagerException;
import org.sonatype.security.authorization.Role;
import org.sonatype.security.rest.AbstractSecurityPlexusResource;
import org.sonatype.security.rest.model.PlexusRoleListResourceResponse;

@Singleton
@Typed(value={PlexusResource.class})
@Named(value="PlexusRoleListPlexusResource")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
@Path(value="/plexus_roles/{sourceId}")
@Deprecated
public class PlexusRoleListPlexusResource
extends AbstractSecurityPlexusResource {
    public static final String SOURCE_ID_KEY = "sourceId";
    public static final String RESOURCE_URI = "/plexus_roles/{sourceId}";

    public Object getPayloadInstance() {
        return null;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/plexus_roles/*", "authcBasic,perms[security:roles]");
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    @GET
    @ResourceMethodSignature(output=PlexusRoleListResourceResponse.class, pathParams={@PathParam(value="sourceId")})
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        Set roles;
        String source = this.getSourceId(request);
        try {
            roles = this.getSecuritySystem().listRoles(source);
        }
        catch (NoSuchAuthorizationManagerException e) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "Role Source '" + source + "' could not be found.");
        }
        PlexusRoleListResourceResponse resourceResponse = new PlexusRoleListResourceResponse();
        for (Role role : roles) {
            resourceResponse.addData(this.securityToRestModel(role));
        }
        return resourceResponse;
    }

    protected String getSourceId(Request request) {
        return this.getRequestAttribute(request, SOURCE_ID_KEY);
    }
}

