/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.rest.roles;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.sonatype.security.rest.model.RoleAndPrivilegeListFilterResourceRequest;
import org.sonatype.security.rest.model.RoleAndPrivilegeListResource;

public class FilterRequest {
    private final boolean showPrivileges;
    private final boolean showRoles;
    private final boolean showExternalRoles;
    private final boolean onlySelected;
    private final String text;
    private final List<String> roleIds;
    private final List<String> privilegeIds;
    private final List<String> hiddenRoleIds;
    private final List<String> hiddenPrivilegeIds;
    private final String userId;

    public FilterRequest(RoleAndPrivilegeListFilterResourceRequest request) {
        this.showPrivileges = !request.getData().isNoPrivileges();
        this.showRoles = !request.getData().isNoRoles();
        this.showExternalRoles = !request.getData().isNoExternalRoles();
        this.onlySelected = request.getData().isOnlySelected();
        this.text = request.getData().getName();
        this.roleIds = request.getData().getSelectedRoleIds();
        this.privilegeIds = request.getData().getSelectedPrivilegeIds();
        this.hiddenRoleIds = request.getData().getHiddenRoleIds();
        this.hiddenPrivilegeIds = request.getData().getHiddenPrivilegeIds();
        this.userId = request.getData().getUserId();
    }

    public boolean isShowPrivileges() {
        return this.showPrivileges;
    }

    public boolean isShowRoles() {
        return this.showRoles;
    }

    public boolean isShowExternalRoles() {
        return this.showExternalRoles;
    }

    public boolean isOnlySelected() {
        return this.onlySelected;
    }

    public String getText() {
        return this.text;
    }

    public List<String> getRoleIds() {
        return this.roleIds;
    }

    public List<String> getPrivilegeIds() {
        return this.privilegeIds;
    }

    public List<String> getHiddenRoleIds() {
        return this.hiddenRoleIds;
    }

    public List<String> getHiddenPrivilegeIds() {
        return this.hiddenPrivilegeIds;
    }

    public String getUserId() {
        return this.userId;
    }

    public boolean applies(RoleAndPrivilegeListResource resource) {
        return resource != null && (resource.getType().equals("role") ? (this.isShowRoles() && !resource.isExternal() && (this.getUserId() == null || !this.getRoleIds().isEmpty()) || this.isShowExternalRoles() && resource.isExternal()) && !this.getHiddenRoleIds().contains(resource.getId()) && (resource.isExternal() || this.getRoleIds().isEmpty() && !this.isOnlySelected() || this.getRoleIds().contains(resource.getId())) && (StringUtils.isEmpty((String)this.getText()) || Pattern.compile(Pattern.quote(this.getText()), 2).matcher(resource.getName()).find()) : resource.getType().equals("privilege") && this.isShowPrivileges() && !this.getHiddenPrivilegeIds().contains(resource.getId()) && (this.getPrivilegeIds().isEmpty() && !this.isOnlySelected() || this.getPrivilegeIds().contains(resource.getId())) && (StringUtils.isEmpty((String)this.getText()) || Pattern.compile(Pattern.quote(this.getText()), 2).matcher(resource.getName()).find()));
    }
}

