/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.rest.roles;

import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResource;
import org.sonatype.security.authorization.AuthorizationManager;
import org.sonatype.security.authorization.NoSuchAuthorizationManagerException;
import org.sonatype.security.authorization.NoSuchRoleException;
import org.sonatype.security.authorization.Role;
import org.sonatype.security.rest.model.ExternalRoleMappingResource;
import org.sonatype.security.rest.model.ExternalRoleMappingResourceResponse;
import org.sonatype.security.rest.roles.AbstractRolePlexusResource;

@Singleton
@Typed(value={PlexusResource.class})
@Named(value="ExternalRoleMappingPlexusResource")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
@Path(value="/external_role_map/{sourceId}/{roleId}")
public class ExternalRoleMappingPlexusResource
extends AbstractRolePlexusResource {
    public static final String SOURCE_ID_KEY = "sourceId";
    public static final String ROLE_ID_KEY = "roleId";
    public static final String RESOURCE_URI = "/external_role_map/{sourceId}/{roleId}";

    public Object getPayloadInstance() {
        return null;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/external_role_map/*/*", "authcBasic,perms[security:roles]");
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    @GET
    @ResourceMethodSignature(output=ExternalRoleMappingResourceResponse.class, pathParams={@PathParam(value="sourceId"), @PathParam(value="roleId")})
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        Role defaultRole;
        Role role;
        AuthorizationManager source;
        String sourceId = this.getSourceId(request);
        String roleId = this.getRoleId(request);
        try {
            source = this.getSecuritySystem().getAuthorizationManager(sourceId);
        }
        catch (NoSuchAuthorizationManagerException e) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Invalid source id '" + sourceId + "'", (Throwable)e);
        }
        try {
            role = source.getRole(roleId);
        }
        catch (NoSuchRoleException e) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "Invalid role id '" + roleId + "' on realm '" + sourceId + "'", (Throwable)e);
        }
        try {
            defaultRole = this.getSecuritySystem().getAuthorizationManager("default").getRole(roleId);
        }
        catch (NoSuchRoleException e) {
            defaultRole = null;
        }
        catch (NoSuchAuthorizationManagerException e) {
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, "Unable to load 'default' realm", (Throwable)e);
        }
        ExternalRoleMappingResourceResponse result = new ExternalRoleMappingResourceResponse();
        ExternalRoleMappingResource resource = new ExternalRoleMappingResource();
        result.setData(resource);
        resource.setDefaultRole(this.securityToRestModel(defaultRole));
        resource.addMappedRole(this.securityToRestModel(role));
        return result;
    }

    protected String getSourceId(Request request) {
        return this.getRequestAttribute(request, SOURCE_ID_KEY);
    }

    protected String getRoleId(Request request) {
        return this.getRequestAttribute(request, ROLE_ID_KEY);
    }
}

