/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.rest.roles;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.commons.lang.StringUtils;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResource;
import org.sonatype.security.authorization.NoSuchAuthorizationManagerException;
import org.sonatype.security.authorization.Role;
import org.sonatype.security.rest.model.ExternalRoleMappingListResourceResponse;
import org.sonatype.security.rest.model.ExternalRoleMappingResource;
import org.sonatype.security.rest.roles.AbstractRolePlexusResource;

@Singleton
@Typed(value={PlexusResource.class})
@Named(value="ExternalRoleMappingListPlexusResource")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
@Path(value="/external_role_map/{sourceId}")
public class ExternalRoleMappingListPlexusResource
extends AbstractRolePlexusResource {
    public static final String SOURCE_ID_KEY = "sourceId";
    public static final String RESOURCE_URI = "/external_role_map/{sourceId}";

    public Object getPayloadInstance() {
        return null;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/external_role_map/*", "authcBasic,perms[security:roles]");
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    @GET
    @ResourceMethodSignature(output=ExternalRoleMappingListResourceResponse.class, pathParams={@PathParam(value="sourceId")})
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        String source = this.getSourceId(request);
        try {
            Set roles = this.getSecuritySystem().listRoles(source);
            if (roles == null) {
                throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "Role Source '" + source + "' could not be found.");
            }
            Set defaultRoles = this.getSecuritySystem().listRoles("default");
            HashMap<Role, HashSet<Role>> roleMap = new HashMap<Role, HashSet<Role>>();
            for (Role defaultRole : defaultRoles) {
                for (Role role : roles) {
                    if (StringUtils.equals((String)defaultRole.getSource(), (String)role.getSource()) || !StringUtils.equals((String)defaultRole.getRoleId(), (String)role.getRoleId())) continue;
                    HashSet<Role> mappedRoles = (HashSet<Role>)roleMap.get(defaultRole);
                    if (mappedRoles == null) {
                        mappedRoles = new HashSet<Role>();
                        mappedRoles.add(role);
                        roleMap.put(defaultRole, mappedRoles);
                    } else {
                        mappedRoles.add(role);
                    }
                    roleMap.put(defaultRole, mappedRoles);
                }
            }
            ExternalRoleMappingListResourceResponse result = new ExternalRoleMappingListResourceResponse();
            for (Role defaultRole : roleMap.keySet()) {
                ExternalRoleMappingResource resource = new ExternalRoleMappingResource();
                result.addData(resource);
                resource.setDefaultRole(this.securityToRestModel(defaultRole));
                for (Role mappedRole : (Set)roleMap.get(defaultRole)) {
                    resource.addMappedRole(this.securityToRestModel(mappedRole));
                }
            }
            return result;
        }
        catch (NoSuchAuthorizationManagerException e) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "Role Source '" + source + "' could not be found.");
        }
    }

    protected String getSourceId(Request request) {
        return this.getRequestAttribute(request, SOURCE_ID_KEY);
    }
}

