/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.rest.roles;

import org.restlet.data.Request;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.sonatype.plexus.rest.resource.PlexusResourceException;
import org.sonatype.security.authorization.Role;
import org.sonatype.security.rest.AbstractSecurityPlexusResource;
import org.sonatype.security.rest.model.RoleResource;

public abstract class AbstractRolePlexusResource
extends AbstractSecurityPlexusResource {
    protected static final String ROLE_SOURCE = "default";

    public RoleResource securityToRestModel(Role role, Request request, boolean appendResourceId) {
        RoleResource resource = new RoleResource();
        resource.setDescription(role.getDescription());
        resource.setId(role.getRoleId());
        resource.setName(role.getName());
        String resourceId = "";
        if (appendResourceId) {
            resourceId = resource.getId();
        }
        resource.setResourceURI(this.createChildReference(request, resourceId).toString());
        resource.setUserManaged(!role.isReadOnly());
        for (String roleId : role.getRoles()) {
            resource.addRole(roleId);
        }
        for (String privId : role.getPrivileges()) {
            resource.addPrivilege(privId);
        }
        return resource;
    }

    public Role restToSecurityModel(Role role, RoleResource resource) {
        if (role == null) {
            role = new Role();
        }
        role.setRoleId(resource.getId());
        role.setDescription(resource.getDescription());
        role.setName(resource.getName());
        role.getRoles().clear();
        for (String roleId : resource.getRoles()) {
            role.addRole(roleId);
        }
        role.getPrivileges().clear();
        for (String privId : resource.getPrivileges()) {
            role.addPrivilege(privId);
        }
        return role;
    }

    public void validateRoleContainment(Role role) throws ResourceException {
        if (role.getRoles().size() == 0 && role.getPrivileges().size() == 0) {
            throw new PlexusResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Configuration error.", (Object)this.getErrorResponse("privileges", "One or more roles/privilegs are required."));
        }
    }
}

