/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.rest.privileges;

import java.util.List;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResource;
import org.sonatype.security.realms.privileges.PrivilegeDescriptor;
import org.sonatype.security.realms.privileges.PrivilegePropertyDescriptor;
import org.sonatype.security.realms.tools.ConfigurationManager;
import org.sonatype.security.rest.model.PrivilegeTypePropertyResource;
import org.sonatype.security.rest.model.PrivilegeTypeResource;
import org.sonatype.security.rest.model.PrivilegeTypeResourceResponse;
import org.sonatype.security.rest.privileges.AbstractPrivilegePlexusResource;

@Singleton
@Typed(value={PlexusResource.class})
@Named(value="PrivilegeTypePlexusResource")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
@Path(value="/privilege_types")
public class PrivilegeTypePlexusResource
extends AbstractPrivilegePlexusResource {
    public static final String RESOURCE_URI = "/privilege_types";
    @Inject
    @Named(value="default")
    private ConfigurationManager configurationManager;

    public Object getPayloadInstance() {
        return null;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor(this.getResourceUri(), "authcBasic,perms[security:privilegetypes]");
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    @GET
    @ResourceMethodSignature(output=PrivilegeTypeResourceResponse.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        PrivilegeTypeResourceResponse result = new PrivilegeTypeResourceResponse();
        List privDescriptors = this.configurationManager.listPrivilegeDescriptors();
        for (PrivilegeDescriptor privDescriptor : privDescriptors) {
            PrivilegeTypeResource type = new PrivilegeTypeResource();
            type.setId(privDescriptor.getType());
            type.setName(privDescriptor.getName());
            for (PrivilegePropertyDescriptor propDescriptor : privDescriptor.getPropertyDescriptors()) {
                PrivilegeTypePropertyResource typeProp = new PrivilegeTypePropertyResource();
                typeProp.setId(propDescriptor.getId());
                typeProp.setName(propDescriptor.getName());
                typeProp.setHelpText(propDescriptor.getHelpText());
                typeProp.setType(propDescriptor.getType());
                type.addProperty(typeProp);
            }
            result.addData(type);
        }
        return result;
    }
}

