/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.rest.privileges;

import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResource;
import org.sonatype.security.authorization.AuthorizationManager;
import org.sonatype.security.authorization.NoSuchAuthorizationManagerException;
import org.sonatype.security.authorization.NoSuchPrivilegeException;
import org.sonatype.security.authorization.Privilege;
import org.sonatype.security.rest.model.PrivilegeStatusResourceResponse;
import org.sonatype.security.rest.privileges.AbstractPrivilegePlexusResource;

@Singleton
@Typed(value={PlexusResource.class})
@Named(value="PrivilegePlexusResource")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
@Path(value="/privileges/{privilegeId}")
public class PrivilegePlexusResource
extends AbstractPrivilegePlexusResource {
    public static final String RESOURCE_URI = "/privileges/{privilegeId}";
    protected static final String PRIVILEGE_SOURCE = "default";

    public PrivilegePlexusResource() {
        this.setModifiable(true);
    }

    public Object getPayloadInstance() {
        return null;
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/privileges/*", "authcBasic,perms[security:privileges]");
    }

    protected String getPrivilegeId(Request request) {
        return this.getRequestAttribute(request, "privilegeId");
    }

    @GET
    @ResourceMethodSignature(output=PrivilegeStatusResourceResponse.class, pathParams={@PathParam(value="privilegeId")})
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        PrivilegeStatusResourceResponse result = new PrivilegeStatusResourceResponse();
        Privilege priv = null;
        try {
            AuthorizationManager authzManager = this.getSecuritySystem().getAuthorizationManager(PRIVILEGE_SOURCE);
            priv = authzManager.getPrivilege(this.getPrivilegeId(request));
        }
        catch (NoSuchPrivilegeException e) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "Privilege could not be found.");
        }
        catch (NoSuchAuthorizationManagerException e) {
            this.getLogger().warn("Could not found AuthorizationManager: default", (Throwable)e);
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Authorization Manager for: default could not be found.");
        }
        result.setData(this.securityToRestModel(priv, request, false));
        return result;
    }

    @DELETE
    @ResourceMethodSignature(pathParams={@PathParam(value="privilegeId")})
    public void delete(Context context, Request request, Response response) throws ResourceException {
        try {
            AuthorizationManager authzManager = this.getSecuritySystem().getAuthorizationManager(PRIVILEGE_SOURCE);
            Privilege priv = authzManager.getPrivilege(this.getPrivilegeId(request));
            if (priv.getType().equals("method")) {
                throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Cannot delete an application type privilege");
            }
            authzManager.deletePrivilege(this.getPrivilegeId(request));
        }
        catch (NoSuchPrivilegeException e) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, e.getMessage());
        }
        catch (NoSuchAuthorizationManagerException e) {
            this.getLogger().warn("Could not found AuthorizationManager: default", (Throwable)e);
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Authorization Manager for: default could not be found.");
        }
    }
}

