/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.rest.privileges;

import java.util.Set;
import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResource;
import org.sonatype.security.authorization.Privilege;
import org.sonatype.security.rest.model.PrivilegeListResourceResponse;
import org.sonatype.security.rest.model.PrivilegeStatusResource;
import org.sonatype.security.rest.privileges.AbstractPrivilegePlexusResource;

@Singleton
@Typed(value={PlexusResource.class})
@Named(value="PrivilegeListPlexusResource")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
@Path(value="/privileges")
public class PrivilegeListPlexusResource
extends AbstractPrivilegePlexusResource {
    public static final String RESOURCE_URI = "/privileges";

    public PrivilegeListPlexusResource() {
        this.setRequireStrictChecking(false);
    }

    public Object getPayloadInstance() {
        return null;
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor(this.getResourceUri(), "authcBasic,perms[security:privileges]");
    }

    @GET
    @ResourceMethodSignature(output=PrivilegeListResourceResponse.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        PrivilegeListResourceResponse result = new PrivilegeListResourceResponse();
        Set privs = this.getSecuritySystem().listPrivileges();
        for (Privilege priv : privs) {
            PrivilegeStatusResource res = this.securityToRestModel(priv, request, true);
            if (res == null) continue;
            result.addData(res);
        }
        return result;
    }
}

