/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.rest.privileges;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResource;
import org.sonatype.security.authorization.AuthorizationManager;
import org.sonatype.security.authorization.NoSuchAuthorizationManagerException;
import org.sonatype.security.authorization.NoSuchPrivilegeException;
import org.sonatype.security.authorization.NoSuchRoleException;
import org.sonatype.security.authorization.Privilege;
import org.sonatype.security.authorization.Role;
import org.sonatype.security.rest.AbstractSecurityPlexusResource;
import org.sonatype.security.rest.model.AssignedPrivilegeListResource;
import org.sonatype.security.rest.model.AssignedPrivilegeListResourceResponse;
import org.sonatype.security.rest.model.ParentNode;
import org.sonatype.security.usermanagement.RoleIdentifier;
import org.sonatype.security.usermanagement.User;
import org.sonatype.security.usermanagement.UserNotFoundException;

@Singleton
@Typed(value={PlexusResource.class})
@Named(value="AssignedPrivilegesPlexusResource")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
@Path(value="/assigned_privileges/{userId}")
public class AssignedPrivilegesPlexusResource
extends AbstractSecurityPlexusResource {
    public static final String USER_ID_KEY = "userId";
    public static final String RESOURCE_URI = "/assigned_privileges/{userId}";

    public Object getPayloadInstance() {
        return null;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/assigned_privileges/*", "authcBasic,perms[security:users]");
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    @GET
    @ResourceMethodSignature(output=AssignedPrivilegeListResourceResponse.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        String userId = this.getUserId(request);
        try {
            AssignedPrivilegeListResourceResponse responseResource = new AssignedPrivilegeListResourceResponse();
            User user = this.getSecuritySystem().getUser(userId);
            AuthorizationManager authzManager = this.getSecuritySystem().getAuthorizationManager("default");
            for (RoleIdentifier roleIdentifier : user.getRoles()) {
                try {
                    this.handleRole(authzManager.getRole(roleIdentifier.getRoleId()), null, authzManager, responseResource);
                }
                catch (NoSuchRoleException e) {
                    this.getLogger().debug("Invalid roleId: " + roleIdentifier.getRoleId() + " from source: " + roleIdentifier.getSource() + " not found.");
                }
            }
            return responseResource;
        }
        catch (UserNotFoundException e) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "User: " + userId + " could not be found.");
        }
        catch (NoSuchAuthorizationManagerException e) {
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, "Unable to load default authorization manager");
        }
    }

    protected void handleRole(Role role, List<Role> parentList, AuthorizationManager authzManager, AssignedPrivilegeListResourceResponse response) {
        ArrayList<Role> newParentList = new ArrayList<Role>();
        if (parentList != null) {
            newParentList.addAll(parentList);
        }
        newParentList.add(0, role);
        for (String roleId : role.getRoles()) {
            try {
                this.handleRole(authzManager.getRole(roleId), newParentList, authzManager, response);
            }
            catch (NoSuchRoleException e) {
                this.getLogger().debug("handleRole() failed, roleId: " + roleId + " not found");
            }
        }
        for (String privilegeId : role.getPrivileges()) {
            try {
                this.handlePrivilege(authzManager.getPrivilege(privilegeId), newParentList, response);
            }
            catch (NoSuchPrivilegeException e) {
                this.getLogger().debug("handleRole() failed, privilegeId: " + privilegeId + " not found");
            }
        }
    }

    protected void handlePrivilege(Privilege privilege, List<Role> parentList, AssignedPrivilegeListResourceResponse response) {
        AssignedPrivilegeListResource foundResource = null;
        for (AssignedPrivilegeListResource resource : response.getData()) {
            if (!resource.getId().equals(privilege.getId())) continue;
            foundResource = resource;
            break;
        }
        if (foundResource == null) {
            foundResource = new AssignedPrivilegeListResource();
            foundResource.setId(privilege.getId());
            foundResource.setName(privilege.getName());
            response.addData(foundResource);
        }
        ParentNode root = null;
        ParentNode parent = null;
        for (Role role : parentList) {
            ParentNode newParent = new ParentNode();
            newParent.setId(role.getRoleId());
            newParent.setName(role.getName());
            if (root == null) {
                parent = root = newParent;
                continue;
            }
            parent.addParent(newParent);
            parent = newParent;
        }
        foundResource.addParent(root);
    }

    protected String getUserId(Request request) {
        return this.getRequestAttribute(request, USER_ID_KEY);
    }
}

