/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.rest.authentication;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.permission.WildcardPermission;
import org.apache.shiro.subject.Subject;
import org.restlet.data.Request;
import org.restlet.resource.ResourceException;
import org.sonatype.security.authorization.Privilege;
import org.sonatype.security.rest.AbstractSecurityPlexusResource;
import org.sonatype.security.rest.model.AuthenticationClientPermissions;
import org.sonatype.security.rest.model.ClientPermission;
import org.sonatype.security.usermanagement.User;
import org.sonatype.security.usermanagement.UserNotFoundException;

public abstract class AbstractUIPermissionCalculatingPlexusResource
extends AbstractSecurityPlexusResource {
    private static final int NONE = 0;
    private static final int READ = 1;
    private static final int UPDATE = 2;
    private static final int DELETE = 4;
    private static final int CREATE = 8;
    private static final int ALL = 15;

    protected AuthenticationClientPermissions getClientPermissionsForCurrentUser(Request request) throws ResourceException {
        String username;
        Object principal;
        AuthenticationClientPermissions perms = new AuthenticationClientPermissions();
        Subject subject = SecurityUtils.getSubject();
        if (this.getSecuritySystem().isAnonymousAccessEnabled()) {
            perms.setLoggedIn(!this.getSecuritySystem().getAnonymousUsername().equals(subject.getPrincipal()));
        } else {
            perms.setLoggedIn(subject != null && subject.isAuthenticated());
        }
        if (perms.isLoggedIn() && (principal = subject.getPrincipal()) != null) {
            perms.setLoggedInUsername(principal.toString());
        }
        if (StringUtils.isNotEmpty((String)(username = perms.getLoggedInUsername()))) {
            try {
                User user = this.getSecuritySystem().getUser(username);
                String source = user != null ? user.getSource() : null;
                perms.setLoggedInUserSource(source);
            }
            catch (UserNotFoundException e) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().info("Failed to lookup user: {}", (Object)username, (Object)e);
                }
                this.getLogger().info("Failed to lookup user: {}: {}/{}", new Object[]{username, ((Object)((Object)e)).getClass().getName(), e.getMessage()});
            }
        }
        HashMap<String, Integer> privilegeMap = new HashMap<String, Integer>();
        for (Privilege privilege : this.getSecuritySystem().listPrivileges()) {
            if (!privilege.getType().equals("method")) continue;
            String permission = privilege.getPrivilegeProperty("permission");
            privilegeMap.put(permission, 0);
        }
        this.checkSubjectsPermissions(subject, privilegeMap);
        for (Map.Entry entry : privilegeMap.entrySet()) {
            ClientPermission cPermission = new ClientPermission();
            cPermission.setId((String)entry.getKey());
            cPermission.setValue(((Integer)entry.getValue()).intValue());
            perms.addPermission(cPermission);
        }
        return perms;
    }

    private void checkSubjectsPermissions(Subject subject, Map<String, Integer> privilegeMap) {
        ArrayList<WildcardPermission> permissionList = new ArrayList<WildcardPermission>();
        ArrayList<String> permissionNameList = new ArrayList<String>();
        for (Map.Entry<String, Integer> priv : privilegeMap.entrySet()) {
            permissionList.add(new WildcardPermission(priv.getKey() + ":read"));
            permissionList.add(new WildcardPermission(priv.getKey() + ":create"));
            permissionList.add(new WildcardPermission(priv.getKey() + ":update"));
            permissionList.add(new WildcardPermission(priv.getKey() + ":delete"));
            permissionNameList.add(priv.getKey() + ":read");
            permissionNameList.add(priv.getKey() + ":create");
            permissionNameList.add(priv.getKey() + ":update");
            permissionNameList.add(priv.getKey() + ":delete");
        }
        if (subject != null) {
            boolean[] boolResults = subject.isPermitted(permissionList);
            HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>();
            for (int ii = 0; ii < permissionList.size(); ++ii) {
                String permissionName = (String)permissionNameList.get(ii);
                boolean b = boolResults[ii];
                resultMap.put(permissionName, b);
            }
            for (Map.Entry<String, Integer> priv : privilegeMap.entrySet()) {
                boolean readPriv = (Boolean)resultMap.get(priv.getKey() + ":read");
                boolean createPriv = (Boolean)resultMap.get(priv.getKey() + ":create");
                boolean updaetPriv = (Boolean)resultMap.get(priv.getKey() + ":update");
                boolean deletePriv = (Boolean)resultMap.get(priv.getKey() + ":delete");
                int perm = 0;
                if (readPriv) {
                    perm |= 1;
                }
                if (createPriv) {
                    perm |= 8;
                }
                if (updaetPriv) {
                    perm |= 2;
                }
                if (deletePriv) {
                    perm |= 4;
                }
                priv.setValue(perm);
            }
        } else {
            for (Map.Entry<String, Integer> priv : privilegeMap.entrySet()) {
                priv.setValue(0);
            }
        }
    }
}

