/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.rest;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import org.apache.commons.lang.StringEscapeUtils;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Status;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.configuration.validation.ValidationMessage;
import org.sonatype.configuration.validation.ValidationResponse;
import org.sonatype.nexus.rest.model.AliasingListConverter;
import org.sonatype.nexus.rest.model.HtmlUnescapeStringConverter;
import org.sonatype.plexus.rest.ReferenceFactory;
import org.sonatype.plexus.rest.resource.AbstractPlexusResource;
import org.sonatype.plexus.rest.resource.PlexusResourceException;
import org.sonatype.plexus.rest.resource.error.ErrorMessage;
import org.sonatype.plexus.rest.resource.error.ErrorResponse;
import org.sonatype.security.SecuritySystem;
import org.sonatype.security.authorization.AuthorizationManager;
import org.sonatype.security.authorization.NoSuchAuthorizationManagerException;
import org.sonatype.security.authorization.NoSuchRoleException;
import org.sonatype.security.authorization.Role;
import org.sonatype.security.rest.model.PlexusRoleResource;
import org.sonatype.security.rest.model.PlexusUserResource;
import org.sonatype.security.rest.model.RoleAndPrivilegeListFilterResource;
import org.sonatype.security.rest.model.RoleAndPrivilegeListResource;
import org.sonatype.security.rest.model.RoleResource;
import org.sonatype.security.rest.model.UserChangePasswordResource;
import org.sonatype.security.rest.model.UserResource;
import org.sonatype.security.usermanagement.DefaultUser;
import org.sonatype.security.usermanagement.RoleIdentifier;
import org.sonatype.security.usermanagement.User;
import org.sonatype.security.usermanagement.UserStatus;

@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
public abstract class AbstractSecurityPlexusResource
extends AbstractPlexusResource {
    @Inject
    private SecuritySystem securitySystem;
    protected static final String DEFAULT_SOURCE = "default";
    @Inject
    protected ReferenceFactory referenceFactory;

    protected SecuritySystem getSecuritySystem() {
        return this.securitySystem;
    }

    protected ErrorResponse getErrorResponse(String id, String msg) {
        ErrorResponse ner = new ErrorResponse();
        ErrorMessage ne = new ErrorMessage();
        ne.setId(id);
        ne.setMsg(msg);
        ner.addError(ne);
        return ner;
    }

    protected void handleInvalidConfigurationException(InvalidConfigurationException e) throws PlexusResourceException {
        ErrorResponse errorResponse;
        this.getLogger().debug("Configuration error!", (Throwable)e);
        ValidationResponse vr = e.getValidationResponse();
        if (vr != null && vr.getValidationErrors().size() > 0) {
            ValidationMessage vm = (ValidationMessage)vr.getValidationErrors().get(0);
            errorResponse = this.getErrorResponse(vm.getKey(), vm.getShortMessage());
        } else {
            errorResponse = this.getErrorResponse("*", e.getMessage());
        }
        throw new PlexusResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Configuration error.", (Object)errorResponse);
    }

    protected UserResource securityToRestModel(User user, Request request, boolean appendResourceId) {
        UserResource resource = new UserResource();
        resource.setEmail(user.getEmailAddress());
        resource.setFirstName(user.getFirstName());
        resource.setLastName(user.getLastName());
        resource.setStatus(user.getStatus().name());
        resource.setUserId(user.getUserId());
        String resourceId = "";
        if (appendResourceId) {
            resourceId = resource.getUserId();
        }
        resource.setResourceURI(this.createChildReference(request, resourceId).toString());
        for (RoleIdentifier role : user.getRoles()) {
            resource.addRole(role.getRoleId());
        }
        return resource;
    }

    protected User restToSecurityModel(User user, UserResource resource) throws InvalidConfigurationException {
        if (user == null) {
            user = new DefaultUser();
        }
        this.checkUsersStatus(resource.getStatus());
        user.setEmailAddress(resource.getEmail());
        user.setFirstName(resource.getFirstName());
        user.setLastName(resource.getLastName());
        user.setStatus(UserStatus.valueOf((String)resource.getStatus()));
        user.setUserId(resource.getUserId());
        user.setSource(DEFAULT_SOURCE);
        HashSet<RoleIdentifier> roles = new HashSet<RoleIdentifier>();
        for (String roleId : resource.getRoles()) {
            roles.add(new RoleIdentifier(DEFAULT_SOURCE, roleId));
        }
        user.setRoles(roles);
        return user;
    }

    protected PlexusUserResource securityToRestModel(User user) {
        PlexusUserResource resource = new PlexusUserResource();
        resource.setUserId(user.getUserId());
        resource.setSource(user.getSource());
        resource.setFirstName(user.getFirstName());
        resource.setLastName(user.getLastName());
        resource.setEmail(user.getEmailAddress());
        resource.setStatus(user.getStatus().name());
        for (RoleIdentifier role : user.getRoles()) {
            resource.addRole(this.securityToRestModel(role));
        }
        return resource;
    }

    protected PlexusRoleResource securityToRestModel(Role role) {
        if (role == null) {
            return null;
        }
        PlexusRoleResource roleResource = new PlexusRoleResource();
        roleResource.setRoleId(role.getRoleId());
        roleResource.setName(role.getName());
        roleResource.setSource(role.getSource());
        return roleResource;
    }

    protected List<PlexusUserResource> securityToRestModel(Set<User> users) {
        ArrayList<PlexusUserResource> restUsersList = new ArrayList<PlexusUserResource>();
        for (User user : users) {
            restUsersList.add(this.securityToRestModel(user));
        }
        return restUsersList;
    }

    protected PlexusRoleResource securityToRestModel(RoleIdentifier role) {
        String roleName = role.getRoleId();
        SecuritySystem securitySystem = this.getSecuritySystem();
        try {
            AuthorizationManager authzManager = securitySystem.getAuthorizationManager(DEFAULT_SOURCE);
            roleName = authzManager.getRole(role.getRoleId()).getName();
        }
        catch (NoSuchAuthorizationManagerException e) {
            this.getLogger().warn("Failed to lookup the users Role: " + role.getRoleId() + " source: " + role.getSource() + " but the user has this role.", (Throwable)e);
        }
        catch (NoSuchRoleException e) {
            if (DEFAULT_SOURCE.equals(role.getSource())) {
                this.getLogger().warn("Failed to lookup the users Role: " + role.getRoleId() + " source: " + role.getSource() + " but the user has this role.", (Throwable)e);
            }
            this.getLogger().debug("Failed to lookup the users Role: " + role.getRoleId() + " source: " + role.getSource() + " falling back to the roleId for the role's name.");
        }
        PlexusRoleResource roleResource = new PlexusRoleResource();
        roleResource.setRoleId(role.getRoleId());
        roleResource.setName(roleName);
        roleResource.setSource(role.getSource());
        return roleResource;
    }

    protected Reference createChildReference(Request request, String childPath) {
        return this.referenceFactory.createChildReference(request, childPath);
    }

    protected void checkUsersStatus(String status) throws InvalidConfigurationException {
        boolean found = false;
        for (UserStatus userStatus : UserStatus.values()) {
            if (!userStatus.name().equals(status)) continue;
            found = true;
        }
        if (!found) {
            ValidationResponse response = new ValidationResponse();
            response.addValidationError(new ValidationMessage("status", "Users status is not valid."));
            throw new InvalidConfigurationException(response);
        }
    }

    protected String getRequestAttribute(Request request, String key) {
        return this.getRequestAttribute(request, key, true);
    }

    protected String getRequestAttribute(Request request, String key, boolean decode) {
        String value = request.getAttributes().get(key).toString();
        if (decode) {
            try {
                return URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.getLogger().warn("Failed to decode URL attribute.", (Throwable)e);
            }
        }
        return value;
    }

    public void configureXStream(XStream xstream) {
        super.configureXStream(xstream);
        xstream.registerLocalConverter(UserChangePasswordResource.class, "oldPassword", (SingleValueConverter)new HtmlUnescapeStringConverter(true));
        xstream.registerLocalConverter(UserChangePasswordResource.class, "newPassword", (SingleValueConverter)new HtmlUnescapeStringConverter(true));
        xstream.registerLocalConverter(RoleResource.class, "id", (SingleValueConverter)new HtmlUnescapeStringConverter(true));
        xstream.registerLocalConverter(UserResource.class, "userId", (SingleValueConverter)new HtmlUnescapeStringConverter(true));
        xstream.registerLocalConverter(UserResource.class, "password", (SingleValueConverter)new HtmlUnescapeStringConverter(true));
        xstream.registerLocalConverter(RoleAndPrivilegeListResource.class, "id", (SingleValueConverter)new HtmlUnescapeStringConverter(true));
        xstream.registerLocalConverter(UserResource.class, "roles", (Converter)new HtmlUnescapeStringCollectionConverter("role"));
        xstream.registerLocalConverter(RoleResource.class, "roles", (Converter)new HtmlUnescapeStringCollectionConverter("role"));
        xstream.registerLocalConverter(RoleResource.class, "privileges", (Converter)new HtmlUnescapeStringCollectionConverter("privilege"));
        xstream.registerLocalConverter(RoleAndPrivilegeListFilterResource.class, "selectedRoleIds", (Converter)new HtmlUnescapeStringCollectionConverter("selectedRoleId"));
        xstream.registerLocalConverter(RoleAndPrivilegeListFilterResource.class, "selectedPrivilegeIds", (Converter)new HtmlUnescapeStringCollectionConverter("selectedPrivilegeId"));
        xstream.registerLocalConverter(RoleAndPrivilegeListFilterResource.class, "hiddenRoleIds", (Converter)new HtmlUnescapeStringCollectionConverter("hiddenRoleId"));
        xstream.registerLocalConverter(RoleAndPrivilegeListFilterResource.class, "hiddenPrivilegeIds", (Converter)new HtmlUnescapeStringCollectionConverter("hiddenPrivilegeId"));
    }

    private static class HtmlUnescapeStringCollectionConverter
    extends AliasingListConverter {
        public HtmlUnescapeStringCollectionConverter(String alias) {
            super(String.class, alias);
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            List unmarshal = (List)super.unmarshal(reader, context);
            return Lists.newArrayList((Iterable)Collections2.transform((Collection)unmarshal, (Function)new Function(){

                @Nullable
                public Object apply(@Nullable Object input) {
                    if (input instanceof String) {
                        return StringEscapeUtils.unescapeHtml((String)((String)input));
                    }
                    return input;
                }
            }));
        }
    }
}

