/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.restlet1x.internal;

import com.google.common.base.Preconditions;
import com.noelios.restlet.http.HttpServerConverter;
import com.noelios.restlet.http.HttpServerHelper;
import java.io.EOFException;
import java.io.IOException;
import java.util.Enumeration;
import javax.inject.Singleton;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.sonatype.nexus.restlet1x.internal.NexusHttpServerConverter;
import org.sonatype.plexus.rest.PlexusServerServlet;
import org.sonatype.sisu.goodies.common.Throwables2;

@Singleton
class RestletServlet
extends PlexusServerServlet {
    private static final long serialVersionUID = -840934203229475592L;
    private static final Logger log = LoggerFactory.getLogger(RestletServlet.class);
    private DelegatingServletConfig servletConfig = new DelegatingServletConfig();

    RestletServlet() {
    }

    public void init() throws ServletException {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        try {
            super.init();
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Preconditions.checkNotNull((Object)request);
        Preconditions.checkNotNull((Object)response);
        String uri = request.getRequestURI();
        if (request.getQueryString() != null) {
            uri = String.format("%s?%s", uri, request.getQueryString());
        }
        if (log.isDebugEnabled()) {
            log.debug("Processing: {} {} ({})", new Object[]{request.getMethod(), uri, request.getRequestURL()});
        }
        MDC.put((String)((Object)((Object)this)).getClass().getName(), (String)uri);
        try {
            super.service(request, response);
        }
        catch (EOFException e) {
            if (log.isDebugEnabled()) {
                log.warn(e.toString(), (Throwable)e);
            } else {
                log.warn(Throwables2.explain((Throwable)e));
            }
            response.sendError(500);
        }
        finally {
            MDC.remove((String)((Object)((Object)this)).getClass().getName());
        }
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public HttpServerHelper getServer(HttpServletRequest request) {
        HttpServerHelper server = super.getServer(request);
        server.setConverter((HttpServerConverter)new NexusHttpServerConverter(server.getContext()));
        return server;
    }

    private class DelegatingServletConfig
    implements ServletConfig {
        private DelegatingServletConfig() {
        }

        public String getServletName() {
            return "nexus";
        }

        public ServletContext getServletContext() {
            return RestletServlet.super.getServletConfig().getServletContext();
        }

        public String getInitParameter(String name) {
            return RestletServlet.super.getServletConfig().getInitParameter(name);
        }

        public Enumeration getInitParameterNames() {
            return RestletServlet.super.getServletConfig().getInitParameterNames();
        }
    }
}

