/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.restlet1x.internal;

import java.util.Collection;
import java.util.Iterator;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.web.servlet.AdviceFilter;

@Named
@Singleton
public class RestletHeaderFilter
extends AdviceFilter {
    private static final String SP = " ";

    protected boolean preHandle(ServletRequest request, ServletResponse response) throws Exception {
        if (response instanceof HttpServletResponse) {
            HttpServletResponse r = (HttpServletResponse)response;
            Collection serverHeaders = r.getHeaders("Server");
            int numHeaders = serverHeaders.size();
            if (numHeaders == 1) {
                r.setHeader("Server", (String)serverHeaders.iterator().next() + SP + "Noelios-Restlet-Engine/1.1.6-SONATYPE-5348-V8");
            } else if (numHeaders == 0) {
                r.setHeader("Server", "Noelios-Restlet-Engine/1.1.6-SONATYPE-5348-V8");
            } else {
                Iterator it = serverHeaders.iterator();
                StringBuilder sb = new StringBuilder((String)it.next());
                while (it.hasNext()) {
                    sb.append(SP).append((String)it.next());
                }
                sb.append(SP).append("Noelios-Restlet-Engine/1.1.6-SONATYPE-5348-V8");
                r.setHeader("Server", sb.toString());
            }
        }
        return true;
    }
}

