/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.restlet1x.internal;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.Filter;
import org.apache.shiro.web.filter.mgt.FilterChainResolver;
import org.sonatype.nexus.restlet1x.internal.RestletServletModule;
import org.sonatype.nexus.security.filter.FilterProviderSupport;
import org.sonatype.nexus.security.filter.authz.NexusTargetMappingAuthorizationFilter;

@Named
public class Restlet1xModule
extends AbstractModule {
    protected void configure() {
        this.install((Module)new RestletServletModule());
        this.requireBinding(FilterChainResolver.class);
        this.bind(FilterProviderSupport.filterKey((String)"trperms")).toProvider(TargetRepositoryFilterProvider.class);
        this.bind(FilterProviderSupport.filterKey((String)"tiperms")).toProvider(TargetRepositoryIndexFilterProvider.class);
        this.bind(FilterProviderSupport.filterKey((String)"tgperms")).toProvider(TargetGroupFilterProvider.class);
        this.bind(FilterProviderSupport.filterKey((String)"tgiperms")).toProvider(TargetGroupIndexFilterProvider.class);
    }

    @Singleton
    static class TargetGroupIndexFilterProvider
    extends FilterProviderSupport {
        @Inject
        public TargetGroupIndexFilterProvider(NexusTargetMappingAuthorizationFilter filter) {
            super((Filter)filter);
            filter.setPathPrefix("/service/local/repo_groups/([^/]*)/index_content(.*)");
            filter.setPathReplacement("/groups/@1/@2");
        }
    }

    @Singleton
    static class TargetGroupFilterProvider
    extends FilterProviderSupport {
        @Inject
        public TargetGroupFilterProvider(NexusTargetMappingAuthorizationFilter filter) {
            super((Filter)filter);
            filter.setPathPrefix("/service/local/repo_groups/([^/]*)/content(.*)");
            filter.setPathReplacement("/groups/@1/@2");
        }
    }

    @Singleton
    static class TargetRepositoryIndexFilterProvider
    extends FilterProviderSupport {
        @Inject
        public TargetRepositoryIndexFilterProvider(NexusTargetMappingAuthorizationFilter filter) {
            super((Filter)filter);
            filter.setPathPrefix("/service/local/repositories/([^/]*)/index_content(.*)");
            filter.setPathReplacement("/repositories/@1/@2");
        }
    }

    @Singleton
    static class TargetRepositoryFilterProvider
    extends FilterProviderSupport {
        @Inject
        public TargetRepositoryFilterProvider(NexusTargetMappingAuthorizationFilter filter) {
            super((Filter)filter);
            filter.setPathPrefix("/service/local/repositories/([^/]*)/content/(.*)");
            filter.setPathReplacement("/repositories/@1/@2");
        }
    }
}

